-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2026, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULL AS TRIGGER_CATALOG,
  NULL AS TRIGGER_SCHEMA,
  name AS TRIGGER_NAME,
  CASE
    WHEN sql LIKE '%INSERT ON%' THEN 'INSERT'
    WHEN sql LIKE '%UPDATE ON%'  THEN 'UPDATE'
    WHEN sql LIKE '%DELETE ON%'  THEN 'DELETE'
    ELSE 'UNKNOWN'
  END
  AS EVENT_MANIPULATION,
  NULL AS EVENT_OBJECT_CATALOG,
  NULL AS EVENT_OBJECT_SCHEMA,
  tbl_name AS EVENT_OBJECT_TABLE,
  0
    AS ACTION_ORDER,
  '' AS ACTION_CONDITION,
  CASE
    WHEN sql LIKE '%ROW%' THEN 'ROW'
    WHEN sql LIKE '%STATEMENT%' THEN 'STATEMENT'
    ELSE 'UNKNOWN'
  END
    AS ACTION_ORIENTATION,
  CASE
    WHEN sql LIKE '%AFTER%' THEN 'AFTER'
    WHEN sql LIKE '%BEFORE%' THEN 'BEFORE'
    ELSE 'INSTEAD OF'
  END
    AS CONDITION_TIMING,
  sql AS ACTION_STATEMENT
FROM
  sqlite_master
WHERE
  type = 'trigger'
ORDER BY
  name
