/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.CryptModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.CryptModuleBuiltinsFactory;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_crypt")
public final class CryptModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CryptModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="crypt", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"word", "salt"})
    @ArgumentsClinic(value={@ArgumentClinic(name="word", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="salt", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    static abstract class CryptNode
    extends PythonBinaryClinicBuiltinNode {
        CryptNode() {
        }

        @Specialization
        Object crypt(VirtualFrame frame, TruffleString word, TruffleString salt, @Bind Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.crypt(this.getPosixSupport(), word, salt);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CryptModuleBuiltinsClinicProviders.CryptNodeClinicProviderGen.INSTANCE;
        }
    }
}

