/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.impl.FileStatusManagerImplKt;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u000223B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0002H\u0016J\b\u0010%\u001a\u00020 H\u0016J\u0012\u0010&\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010(\u001a\u00020 H\u0003J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u000fH\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u000fH\u0016J\u0010\u0010-\u001a\u00020 2\u0006\u0010'\u001a\u00020\u000fH\u0003J\b\u0010.\u001a\u00020 H\u0003J\u0018\u0010/\u001a\u00020 2\u0006\u0010'\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u0018H\u0003J\b\u00101\u001a\u00020 H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0012\u001aB\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u0015 \u0014* \u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0017\u001a6\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000f0\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0018 \u0014*\u001a\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000f0\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/openapi/vcs/impl/FileStatusManagerImpl;", "Lcom/intellij/openapi/vcs/FileStatusManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dirtyLock", "", "dirtyStatuses", "Ljava/util/HashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "dirtyDocuments", "Lit/unimi/dsi/fastutil/objects/Object2BooleanOpenHashMap;", "cachedStatuses", "", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vcs/FileStatus;", "", "whetherExactlyParentToChanged", "", "calcStatus", "virtualFile", "getVcsFileStatus", "calcDirectoryStatus", "status", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FileStatus;)Ljava/lang/Boolean;", "dispose", "", "addFileStatusListener", "listener", "Lcom/intellij/openapi/vcs/FileStatusListener;", "parentDisposable", "fileStatusesChanged", "fileStatusChanged", "file", "updateCachedFileStatuses", "updateFileStatusFor", "initFileStatusFor", "getStatus", "getRecursiveStatus", "refreshFileStatusFromDocument", "processModifiedDocuments", "processModifiedDocument", "isDocumentModified", "waitFor", "MyChangeListListener", "FileStatusManagerDocumentListener", "intellij.platform.vcs.impl"})
@VisibleForTesting
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileStatusManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStatusManagerImpl.kt\ncom/intellij/openapi/vcs/impl/FileStatusManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n60#2,5:373\n60#2,5:378\n60#2,5:383\n60#2,5:388\n60#2,5:394\n1#3:393\n*S KotlinDebug\n*F\n+ 1 FileStatusManagerImpl.kt\ncom/intellij/openapi/vcs/impl/FileStatusManagerImpl\n*L\n127#1:373,5\n135#1:378,5\n141#1:383,5\n144#1:388,5\n275#1:394,5\n*E\n"})
public final class FileStatusManagerImpl
extends FileStatusManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final Object dirtyLock;
    @NotNull
    private final HashSet<VirtualFile> dirtyStatuses;
    @NotNull
    private final Object2BooleanOpenHashMap<VirtualFile> dirtyDocuments;
    private final Map<VirtualFile, FileStatus> cachedStatuses;
    private final Map<VirtualFile, Boolean> whetherExactlyParentToChanged;

    public FileStatusManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.queue = MergingUpdateQueue.Companion.mergingUpdateQueue("FileStatusManagerImpl", 100, coroutineScope);
        this.dirtyLock = new Object();
        this.dirtyStatuses = new HashSet();
        this.dirtyDocuments = new Object2BooleanOpenHashMap();
        this.cachedStatuses = Collections.synchronizedMap(new HashMap());
        this.whetherExactlyParentToChanged = Collections.synchronizedMap(new HashMap());
        SimpleMessageBusConnection connection = this.project.getMessageBus().connect(coroutineScope);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> FileStatusManagerImpl._init_$lambda$0(this, arg_0));
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this::fileStatusesChanged);
        Topic topic2 = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new MyChangeListListener());
        FileStatusProvider.EP_NAME.addChangeListener((AreaInstance)this.project, this::fileStatusesChanged, (Disposable)this.project);
        StartupManager.getInstance((Project)this.project).runAfterOpened(this::fileStatusesChanged);
    }

    private final FileStatus calcStatus(VirtualFile virtualFile) {
        Throwable e$iv;
        Logger $this$debug_u24default$iv;
        FileStatus status;
        for (FileStatusProvider extension : FileStatusProvider.EP_NAME.getExtensions((AreaInstance)this.project)) {
            FileStatus status2 = extension.getFileStatus(virtualFile);
            if (status2 == null) continue;
            Logger logger = FileStatusManager.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            Logger $this$debug_u24default$iv2 = logger;
            Throwable e$iv2 = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv2;
                boolean bl = false;
                logger2.debug("File status for file [" + virtualFile + "] from provider " + extension.getClass().getName() + ": " + status2, e$iv2);
            }
            return status2;
        }
        if (virtualFile.isInLocalFileSystem() && (status = this.getVcsFileStatus(virtualFile)) != null) {
            Logger logger = FileStatusManager.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            Logger $this$debug_u24default$iv3 = logger;
            Throwable e$iv3 = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                Logger logger3 = $this$debug_u24default$iv3;
                boolean bl = false;
                logger3.debug("File status for file [" + virtualFile + "] from vcs provider: " + status, e$iv3);
            }
            return status;
        }
        if (virtualFile.isValid() && virtualFile.is(VFileProperty.SPECIAL)) {
            Logger logger = FileStatusManager.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            $this$debug_u24default$iv = logger;
            e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger4 = $this$debug_u24default$iv;
                boolean bl = false;
                logger4.debug("Default ignored status for special file [" + virtualFile + "]", e$iv);
            }
            FileStatus fileStatus = FileStatus.IGNORED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"IGNORED");
            return fileStatus;
        }
        Logger logger = FileStatusManager.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        $this$debug_u24default$iv = logger;
        e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger5 = $this$debug_u24default$iv;
            boolean bl = false;
            logger5.debug("Default not_changed status for file [" + virtualFile + "]", e$iv);
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
        return fileStatus;
    }

    private final FileStatus getVcsFileStatus(VirtualFile virtualFile) {
        if (ProjectLevelVcsManager.Companion.getInstance(this.project).getVcsFor(virtualFile) == null) {
            if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                return FileStatus.SUPPRESSED;
            }
            return null;
        }
        FileStatus fileStatus = ChangeListManager.getInstance((Project)this.project).getStatus(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        FileStatus status = fileStatus;
        if (!Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED)) {
            return status;
        }
        return FileStatusManagerImplKt.access$isDocumentModified(virtualFile) ? FileStatus.MODIFIED : null;
    }

    private final Boolean calcDirectoryStatus(VirtualFile virtualFile, FileStatus status) {
        if (!Intrinsics.areEqual((Object)FileStatus.NOT_CHANGED, (Object)status) || !VcsConfiguration.getInstance((Project)this.project).SHOW_DIRTY_RECURSIVELY) {
            return null;
        }
        ThreeState threeState = ChangeListManager.getInstance((Project)this.project).haveChangesUnder(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"haveChangesUnder(...)");
        ThreeState state = threeState;
        return ThreeState.YES == state ? Boolean.valueOf(true) : (ThreeState.UNSURE == state ? Boolean.valueOf(false) : null);
    }

    public void dispose() {
        this.cachedStatuses.clear();
    }

    public void addFileStatusListener(@NotNull FileStatusListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(parentDisposable);
        Topic topic = FileStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileStatusesChanged() {
        Object object = this.dirtyLock;
        synchronized (object) {
            boolean bl = false;
            this.cachedStatuses.clear();
            this.whetherExactlyParentToChanged.clear();
            this.dirtyStatuses.clear();
            Unit unit = Unit.INSTANCE;
        }
        ApplicationManager.getApplication().invokeLater(() -> FileStatusManagerImpl.fileStatusesChanged$lambda$1(this), ModalityState.any(), this.project.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileStatusChanged(@Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        if (!file.isValid()) {
            Object object = this.dirtyLock;
            synchronized (object) {
                boolean $i$a$-synchronized-FileStatusManagerImpl$fileStatusChanged$32 = false;
                this.cachedStatuses.remove(file);
                Boolean $i$a$-synchronized-FileStatusManagerImpl$fileStatusChanged$32 = this.whetherExactlyParentToChanged.remove(file);
            }
            return;
        }
        if (!FileStatusManagerImplKt.access$isSupported(file)) {
            return;
        }
        if (this.cachedStatuses.get(file) == null) {
            return;
        }
        Object object = this.dirtyLock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.dirtyStatuses.add(file);
        }
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)this, (Object)"file status update", this::updateCachedFileStatuses);
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        this.queue.queue((Update)disposableUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final void updateCachedFileStatuses() {
        List toRefresh = null;
        Iterator iterator = this.dirtyLock;
        synchronized (iterator) {
            boolean $i$a$-synchronized-FileStatusManagerImpl$updateCachedFileStatuses$22 = false;
            toRefresh = CollectionsKt.toList((Iterable)this.dirtyStatuses);
            this.dirtyStatuses.clear();
            Unit $i$a$-synchronized-FileStatusManagerImpl$updateCachedFileStatuses$22 = Unit.INSTANCE;
        }
        ArrayList<VirtualFile> updatedFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file : toRefresh) {
            boolean wasUpdated = this.updateFileStatusFor(file);
            if (!wasUpdated) continue;
            updatedFiles.add(file);
        }
        ApplicationManager.getApplication().invokeLater(() -> FileStatusManagerImpl.updateCachedFileStatuses$lambda$1(this, updatedFiles), ModalityState.any(), this.project.getDisposed());
    }

    private final boolean updateFileStatusFor(VirtualFile file) {
        FileStatus newStatus = this.calcStatus(file);
        FileStatus oldStatus = this.cachedStatuses.put(file, newStatus);
        if (oldStatus == newStatus) {
            return false;
        }
        this.whetherExactlyParentToChanged.put(file, this.calcDirectoryStatus(file, newStatus));
        return true;
    }

    private final FileStatus initFileStatusFor(VirtualFile file) {
        FileStatus newStatus = this.calcStatus(file);
        this.cachedStatuses.put(file, newStatus);
        this.whetherExactlyParentToChanged.put(file, this.calcDirectoryStatus(file, newStatus));
        return newStatus;
    }

    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file) {
        FileStatus fileStatus;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FileStatusManagerImplKt.access$isSupported(file)) {
            FileStatus fileStatus2 = FileStatus.SUPPRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"SUPPRESSED");
            return fileStatus2;
        }
        FileStatus status = this.cachedStatuses.get(file);
        Logger logger = FileStatusManager.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            logger2.debug("Cached status for file [" + file + "] is " + status, e$iv);
        }
        if ((fileStatus = status) == null) {
            fileStatus = this.initFileStatusFor(file);
        }
        return fileStatus;
    }

    @NotNull
    public FileStatus getRecursiveStatus(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileStatus status = this.getStatus(file);
        if (status != FileStatus.NOT_CHANGED) {
            return status;
        }
        if (file.isValid() && file.isDirectory()) {
            FileStatus fileStatus;
            Boolean bl = this.whetherExactlyParentToChanged.get(file);
            if (bl == null) {
                FileStatus fileStatus2 = FileStatus.NOT_CHANGED;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"NOT_CHANGED");
                return fileStatus2;
            }
            boolean immediate = bl;
            if (immediate) {
                FileStatus fileStatus3 = FileStatus.NOT_CHANGED_IMMEDIATE;
                fileStatus = fileStatus3;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus3, (String)"NOT_CHANGED_IMMEDIATE");
            } else {
                FileStatus fileStatus4 = FileStatus.NOT_CHANGED_RECURSIVE;
                fileStatus = fileStatus4;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus4, (String)"NOT_CHANGED_RECURSIVE");
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
        return fileStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void refreshFileStatusFromDocument(VirtualFile file) {
        if (FileStatusManager.LOG.isDebugEnabled()) {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            Document document2 = document;
            FileStatusManager.LOG.debug("[refreshFileStatusFromDocument] file modificationStamp: " + file.getModificationStamp() + ", document modificationStamp: " + (document2 != null ? Long.valueOf(document2.getModificationStamp()) : null));
        }
        boolean isDocumentModified = FileStatusManagerImplKt.access$isDocumentModified(file);
        Object object = this.dirtyLock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.dirtyDocuments.put((Object)file, isDocumentModified);
        }
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)this, (Object)"refresh from document", this::processModifiedDocuments);
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        this.queue.queue((Update)disposableUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final void processModifiedDocuments() {
        Object2BooleanOpenHashMap toRefresh = null;
        Object object = this.dirtyLock;
        synchronized (object) {
            boolean bl = false;
            toRefresh = new Object2BooleanOpenHashMap((Object2BooleanMap)this.dirtyDocuments);
            this.dirtyDocuments.clear();
            Unit unit = Unit.INSTANCE;
        }
        ((Object2BooleanMap)toRefresh).forEach((arg_0, arg_1) -> FileStatusManagerImpl.processModifiedDocuments$lambda$1((Function2)new Function2<VirtualFile, Boolean, Unit>((Object)this){

            public final void invoke(VirtualFile p0, boolean p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                FileStatusManagerImpl.access$processModifiedDocument((FileStatusManagerImpl)((Object)this.receiver), p0, p1);
            }
        }, arg_0, arg_1));
    }

    @RequiresBackgroundThread
    private final void processModifiedDocument(VirtualFile file, boolean isDocumentModified) {
        ChangeProvider cp;
        if (FileStatusManager.LOG.isDebugEnabled()) {
            Document document = (Document)ApplicationManager.getApplication().runReadAction(() -> FileStatusManagerImpl.processModifiedDocument$lambda$0(file));
            Document document2 = document;
            FileStatusManager.LOG.debug("[processModifiedDocument] isModified: " + isDocumentModified + ", file modificationStamp: " + file.getModificationStamp() + ", document modificationStamp: " + (document2 != null ? Long.valueOf(document2.getModificationStamp()) : null));
        }
        VirtualFile virtualFile = VcsUtil.resolveSymlinkIfNeeded((Project)this.project, (VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"resolveSymlinkIfNeeded(...)");
        VirtualFile vcsFile = virtualFile;
        AbstractVcs abstractVcs = ProjectLevelVcsManager.Companion.getInstance(this.project).getVcsFor(vcsFile);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs vcs = abstractVcs;
        FileStatus cachedStatus = this.cachedStatuses.get(vcsFile);
        if (cachedStatus == FileStatus.MODIFIED && !isDocumentModified) {
            ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)this.project);
            Intrinsics.checkNotNull((Object)readonlyStatusHandler, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl");
            boolean unlockWithPrompt = ((ReadonlyStatusHandlerImpl)readonlyStatusHandler).getState().SHOW_DIALOG;
            if (!unlockWithPrompt) {
                RollbackEnvironment rollbackEnvironment;
                RollbackEnvironment rollbackEnvironment2 = rollbackEnvironment = vcs.getRollbackEnvironment();
                if (rollbackEnvironment2 != null) {
                    rollbackEnvironment2.rollbackIfUnchanged(vcsFile);
                }
            }
        }
        if (cachedStatus != null) {
            boolean isStatusChanged;
            boolean bl = isStatusChanged = cachedStatus != FileStatus.NOT_CHANGED;
            if (isStatusChanged != isDocumentModified) {
                this.fileStatusChanged(vcsFile);
            }
        }
        if ((cp = vcs.getChangeProvider()) != null && cp.isModifiedDocumentTrackingRequired()) {
            boolean isClmStatusChanged;
            FileStatus fileStatus = ChangeListManager.getInstance((Project)this.project).getStatus(vcsFile);
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
            FileStatus status = fileStatus;
            boolean bl = isClmStatusChanged = status != FileStatus.NOT_CHANGED;
            if (isClmStatusChanged != isDocumentModified) {
                VcsDirtyScopeManager.getInstance((Project)this.project).fileDirty(vcsFile);
            }
        }
    }

    @TestOnly
    public final void waitFor() {
        this.queue.waitForAllExecuted(10L, TimeUnit.SECONDS);
        if (this.queue.isFlushing()) {
            this.queue.waitForAllExecuted(10L, TimeUnit.SECONDS);
        }
    }

    private static final void _init_$lambda$0(FileStatusManagerImpl this$0, EditorColorsScheme it) {
        this$0.fileStatusesChanged();
    }

    private static final void fileStatusesChanged$lambda$1(FileStatusManagerImpl this$0) {
        MessageBus messageBus = this$0.project.getMessageBus();
        Topic topic = FileStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((FileStatusListener)messageBus.syncPublisher(topic)).fileStatusesChanged();
    }

    private static final void updateCachedFileStatuses$lambda$1(FileStatusManagerImpl this$0, ArrayList $updatedFiles) {
        MessageBus messageBus = this$0.project.getMessageBus();
        Topic topic = FileStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        FileStatusListener publisher = (FileStatusListener)messageBus.syncPublisher(topic);
        Iterator iterator = $updatedFiles.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            VirtualFile file = (VirtualFile)iterator2.next();
            publisher.fileStatusChanged(file);
        }
    }

    private static final void processModifiedDocuments$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Document processModifiedDocument$lambda$0(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    public static final /* synthetic */ void access$processModifiedDocument(FileStatusManagerImpl $this, VirtualFile file, boolean isDocumentModified) {
        $this.processModifiedDocument(file, isDocumentModified);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/impl/FileStatusManagerImpl$FileStatusManagerDocumentListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "()V", "CHANGED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "bulkUpdateFinished", "document", "Lcom/intellij/openapi/editor/Document;", "unsavedDocumentDropped", "refreshFileStatus", "intellij.platform.vcs.impl"})
    public static final class FileStatusManagerDocumentListener
    implements FileDocumentManagerListener,
    DocumentListener {
        @NotNull
        private final Key<Boolean> CHANGED;

        public FileStatusManagerDocumentListener() {
            Key key = Key.create((String)"FileStatusManagerDocumentListener.document.changed");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            this.CHANGED = key;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            if (document2.isInBulkUpdate()) {
                document2.putUserData(this.CHANGED, (Object)true);
            } else {
                this.refreshFileStatus(document2);
            }
        }

        public void bulkUpdateFinished(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            if (document.getUserData(this.CHANGED) != null) {
                document.putUserData(this.CHANGED, null);
                this.refreshFileStatus(document);
            }
        }

        public void unsavedDocumentDropped(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            this.refreshFileStatus(document);
        }

        private final void refreshFileStatus(Document document) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            if (!file.isInLocalFileSystem()) {
                return;
            }
            if (!FileStatusManagerImplKt.access$isSupported(file)) {
                return;
            }
            ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
            if (projectManager == null) {
                return;
            }
            ProjectManager projectManager2 = projectManager;
            Project[] projectArray = projectManager2.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project : projectArray) {
                FileStatusManagerImpl manager;
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                FileStatusManagerImpl fileStatusManagerImpl = manager = (FileStatusManagerImpl)((Object)project2.getServiceIfCreated(FileStatusManager.class));
                if (fileStatusManagerImpl == null) continue;
                fileStatusManagerImpl.refreshFileStatusFromDocument(file);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/FileStatusManagerImpl$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/FileStatusManagerImpl;)V", "changeListAdded", "", "list", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "changeListRemoved", "changeListUpdateDone", "intellij.platform.vcs.impl"})
    private final class MyChangeListListener
    implements ChangeListListener {
        public void changeListAdded(@NotNull ChangeList list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            FileStatusManagerImpl.this.fileStatusesChanged();
        }

        public void changeListRemoved(@NotNull ChangeList list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            FileStatusManagerImpl.this.fileStatusesChanged();
        }

        public void changeListUpdateDone() {
            FileStatusManagerImpl.this.fileStatusesChanged();
        }
    }
}

