/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitBranchesSearcher;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.GitHandler;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitOutgoingChangesProvider
implements VcsOutgoingChangesProvider<CommittedChangeList> {
    private static final Logger LOG = Logger.getInstance(GitOutgoingChangesProvider.class);
    private final Project myProject;

    public GitOutgoingChangesProvider(Project project) {
        this.myProject = project;
    }

    public Pair<VcsRevisionNumber, List<CommittedChangeList>> getOutgoingChanges(VirtualFile vcsRoot, boolean findRemote) throws VcsException {
        LOG.debug("getOutgoingChanges root: " + vcsRoot.getPath());
        GitBranchesSearcher searcher = new GitBranchesSearcher(this.myProject, vcsRoot, findRemote);
        if (searcher.getLocal() == null || searcher.getRemote() == null) {
            return new Pair(null, Collections.emptyList());
        }
        GitRevisionNumber base = GitOutgoingChangesProvider.getMergeBase(this.myProject, vcsRoot, searcher.getLocal(), searcher.getRemote());
        if (base == null) {
            return new Pair(null, Collections.emptyList());
        }
        List<GitCommittedChangeList> lists = GitUtil.getLocalCommittedChanges(this.myProject, vcsRoot, (Consumer<? super GitHandler>)((Consumer)handler -> handler.addParameters(base.asString() + "..HEAD")));
        return new Pair((Object)base, (Object)ContainerUtil.map(lists, (Function)Functions.identity()));
    }

    @Nullable
    public VcsRevisionNumber getMergeBaseNumber(VirtualFile anyFileUnderRoot) throws VcsException {
        LOG.debug("getMergeBaseNumber parameter: " + anyFileUnderRoot.getPath());
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(anyFileUnderRoot);
        if (repository2 == null) {
            LOG.info("VCS root not found");
            return null;
        }
        GitBranchesSearcher searcher = new GitBranchesSearcher(this.myProject, repository2.getRoot(), true);
        if (searcher.getLocal() == null || searcher.getRemote() == null) {
            LOG.info("local or remote not found");
            return null;
        }
        GitRevisionNumber base = GitOutgoingChangesProvider.getMergeBase(this.myProject, repository2.getRoot(), searcher.getLocal(), searcher.getRemote());
        LOG.debug("found base: " + (base == null ? null : base.asString()));
        return base;
    }

    @Nullable
    private static GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitBranch currentBranch, @NotNull GitBranch branch) throws VcsException {
        if (project == null) {
            GitOutgoingChangesProvider.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitOutgoingChangesProvider.$$$reportNull$$$0(1);
        }
        if (currentBranch == null) {
            GitOutgoingChangesProvider.$$$reportNull$$$0(2);
        }
        if (branch == null) {
            GitOutgoingChangesProvider.$$$reportNull$$$0(3);
        }
        return GitHistoryUtils.getMergeBase(project, root, currentBranch.getFullName(), branch.getFullName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "currentBranch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "branch";
                break;
            }
        }
        objectArray[1] = "git4idea/changes/GitOutgoingChangesProvider";
        objectArray[2] = "getMergeBase";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

