//
// StatementExecutor.h
//
// Library: Data/MySQL
// Package: MySQL
// Module:  StatementExecutor
//
// Definition of the StatementExecutor class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// SPDX-License-Identifier:	BSL-1.0
//


#ifndef Data_MySQL_StatementHandle_INCLUDED
#define Data_MySQL_StatementHandle_INCLUDED


#include "Poco/Data/MySQL/MySQLException.h"
#include <mysql/mysql.h>


namespace Poco {
namespace Data {
namespace MySQL {


class StatementExecutor
	/// MySQL statement executor.
{
public:
	enum State
	{
		STMT_INITED,
		STMT_COMPILED,
		STMT_EXECUTED
	};

	explicit StatementExecutor(MYSQL* mysql);
		/// Creates the StatementExecutor.

	StatementExecutor(const StatementExecutor&) = delete;

	StatementExecutor& operator=(const StatementExecutor&) = delete;

	~StatementExecutor();
		/// Destroys the StatementExecutor.

	int state() const;
		/// Returns the current state.

	void prepare(const std::string& query);
		/// Prepares the statement for execution.

	void bindParams(MYSQL_BIND* params, std::size_t count);
		/// Binds the params.

	void bindResult(MYSQL_BIND* result);
		/// Binds result.

	void execute();
		/// Executes the statement.

	bool fetch();
		/// Fetches the data.

	bool fetchColumn(std::size_t n, MYSQL_BIND *bind);
		/// Fetches the column.

	int getAffectedRowCount() const;

	operator MYSQL_STMT* ();
		/// Cast operator to native handle type.

private:
	MYSQL*      _pSessionHandle;
	MYSQL_STMT* _pHandle;
	int         _state;
	std::size_t _affectedRowCount;
	std::string _query;
};


//
// inlines
//

inline StatementExecutor::operator MYSQL_STMT* ()
{
	return _pHandle;
}


} } } // namespace Poco::Data::MySQL


#endif // Data_MySQL_StatementHandle_INCLUDED
