/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleMonospaced
implements Command {
    private final Pattern2 pattern;

    @Override
    public String startingChars() {
        return "\"";
    }

    public static Command create() {
        return new CommandCreoleMonospaced("^(\"\"(.*?)\"\")");
    }

    private CommandCreoleMonospaced(String p) {
        String p1 = p;
        this.pattern = Pattern2.cmpile(p1);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = fc1.changeFamily(stripe.getSkinParam().getMonospacedFamily());
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m.group(2));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

