/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.algorithm.impl;

import java.util.List;
import java.util.Map;
import org.pentaho.aggdes.algorithm.Algorithm;
import org.pentaho.aggdes.algorithm.Progress;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.algorithm.impl.AggregateImpl;
import org.pentaho.aggdes.algorithm.impl.AlgorithmImpl;
import org.pentaho.aggdes.algorithm.impl.ExhaustiveLatticeImpl;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.util.AggDesUtil;

public class ExhaustiveLatticeAlgorithm
extends AlgorithmImpl {
    @Override
    public Result run(Schema schema, Map<Parameter, Object> parameterValues, Progress progress) {
        this.schema = schema;
        this.onStart(parameterValues, progress);
        ExhaustiveLatticeImpl lattice = new ExhaustiveLatticeImpl(schema);
        double remainingCost = schema.getStatisticsProvider().getFactRowCount();
        return this.runAlgorithm(lattice, remainingCost, 0.0, Integer.MAX_VALUE);
    }

    @Override
    public List<Algorithm.CostBenefit> computeAggregateCosts(Schema schema, Map<Parameter, Object> parameterValues, List<Aggregate> aggregateList) {
        ExhaustiveLatticeImpl lattice = new ExhaustiveLatticeImpl(schema);
        List<AggregateImpl> aggregateImplList = AggDesUtil.cast(aggregateList);
        return lattice.computeAggregateCosts(aggregateImplList);
    }
}

