/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.neuralsearch.util.HybridQueryUtil;
import org.opensearch.search.aggregations.AggregationProcessor;
import org.opensearch.search.internal.SearchContext;

public class HybridAggregationProcessor
implements AggregationProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridAggregationProcessor.class);
    private final AggregationProcessor delegateAggsProcessor;

    public void preProcess(SearchContext context) {
        this.delegateAggsProcessor.preProcess(context);
        if (context.minimumScore() != null && HybridQueryUtil.isHybridQuery(context.query(), context)) {
            context.minimumScore(Float.NEGATIVE_INFINITY);
        }
    }

    public void postProcess(SearchContext context) {
        if (context.numberOfShards() == 1 && HybridQueryUtil.isHybridQuery(context.query(), context)) {
            context.size(context.queryResult().queryResult().topDocs().topDocs.scoreDocs.length);
        }
        this.delegateAggsProcessor.postProcess(context);
    }

    @Generated
    public HybridAggregationProcessor(AggregationProcessor delegateAggsProcessor) {
        this.delegateAggsProcessor = delegateAggsProcessor;
    }
}

