/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.tree;

import com.oracle.labs.mlrg.olcut.config.PropertyException;
import java.util.logging.Logger;
import org.tribuo.Output;
import org.tribuo.common.tree.DecisionTreeTrainer;
import org.tribuo.ensemble.BaggingTrainer;
import org.tribuo.ensemble.EnsembleCombiner;

public class RandomForestTrainer<T extends Output<T>>
extends BaggingTrainer<T> {
    private static final Logger logger = Logger.getLogger(RandomForestTrainer.class.getName());

    private RandomForestTrainer() {
    }

    public RandomForestTrainer(DecisionTreeTrainer<T> trainer, EnsembleCombiner<T> combiner, int numMembers) {
        super(trainer, combiner, numMembers);
        this.postConfig();
    }

    public RandomForestTrainer(DecisionTreeTrainer<T> trainer, EnsembleCombiner<T> combiner, int numMembers, long seed) {
        super(trainer, combiner, numMembers, seed);
        this.postConfig();
    }

    public void postConfig() {
        super.postConfig();
        if (!(this.innerTrainer instanceof DecisionTreeTrainer)) {
            throw new PropertyException("", "innerTrainer", "RandomForestTrainer requires a decision tree innerTrainer");
        }
        DecisionTreeTrainer t = (DecisionTreeTrainer)this.innerTrainer;
        if (t.getFractionFeaturesInSplit() == 1.0f) {
            throw new PropertyException("", "innerTrainer", "RandomForestTrainer requires that the decision tree innerTrainer have fractional features in split.");
        }
        if (t.getUseRandomSplitPoints()) {
            throw new PropertyException("", "innerTrainer", "RandomForestTrainer requires that the decision tree use non-random splitting, but useRandomSplits was true. If you want random splits, use ExtraTreesTrainer instead.");
        }
    }

    protected String ensembleName() {
        return "random-forest-ensemble";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RandomForestTrainer(");
        buffer.append("innerTrainer=");
        buffer.append(this.innerTrainer.toString());
        buffer.append(",combiner=");
        buffer.append(this.combiner.toString());
        buffer.append(",numMembers=");
        buffer.append(this.numMembers);
        buffer.append(",seed=");
        buffer.append(this.seed);
        buffer.append(")");
        return buffer.toString();
    }
}

