"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TITLES = exports.TRACE_TABLE_OPTIONS = exports.TRACE_SERVICE_MAP_MAX_NODES = exports.TRACE_SERVICE_MAP_MAX_EDGES = exports.TRACE_LOGS_FIELD_MAPPNIGS_SETTING = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_MODE_DEFAULT_SETTING = exports.TRACE_CORRELATED_LOGS_INDEX_SETTING = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACES_MAX_NUM = exports.JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_INDEX_NAME = exports.DEFAULT_SS4O_LOGS_INDEX = exports.DEFAULT_SERVICE_MAP_MAX_NODES = exports.DEFAULT_SERVICE_MAP_MAX_EDGES = exports.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = exports.DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const JAEGER_INDEX_NAME = exports.JAEGER_INDEX_NAME = '*jaeger-span-*';
const JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_SERVICE_INDEX_NAME = '*jaeger-service*';
const DATA_PREPPER_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = 'otel-v1-apm-span-*,opensearch_dashboards_sample_data_otel_spans*';
const DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_SERVICE_INDEX_NAME = 'otel-v1-apm-service-map*,opensearch_dashboards_sample_data_otel_service_map*';
const TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATE_FORMAT = 'MM/DD/YYYY HH:mm:ss.SSS';
const TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = 'MMM D, YYYY HH:mm:ss.SSS';
const TRACES_MAX_NUM = exports.TRACES_MAX_NUM = 500;
const TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = 'https://opensearch.org/docs/latest/observability-plugin/trace/index/';
const TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = '/api/observability/trace_analytics/jaeger_indices';
const TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = '/api/observability/trace_analytics/data_prepper_indices';
const TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = '/api/observability/trace_analytics/query';
const TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = 'observability:traceAnalyticsSpanIndices';
const TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = 'observability:traceAnalyticsServiceIndices';
const TRACE_CUSTOM_MODE_DEFAULT_SETTING = exports.TRACE_CUSTOM_MODE_DEFAULT_SETTING = 'observability:traceAnalyticsCustomModeDefault';
const TRACE_CORRELATED_LOGS_INDEX_SETTING = exports.TRACE_CORRELATED_LOGS_INDEX_SETTING = 'observability:traceAnalyticsCorrelatedLogsIndices';
const TRACE_LOGS_FIELD_MAPPNIGS_SETTING = exports.TRACE_LOGS_FIELD_MAPPNIGS_SETTING = 'observability:traceAnalyticsCorrelatedLogsFieldMappings';
const TRACE_SERVICE_MAP_MAX_NODES = exports.TRACE_SERVICE_MAP_MAX_NODES = 'observability:traceAnalyticsServiceMapMaxNodes';
const TRACE_SERVICE_MAP_MAX_EDGES = exports.TRACE_SERVICE_MAP_MAX_EDGES = 'observability:traceAnalyticsServiceMapMaxEdges';
const DEFAULT_SS4O_LOGS_INDEX = exports.DEFAULT_SS4O_LOGS_INDEX = 'ss4o_logs-*,opensearch_dashboards_sample_data_otel_logs*';
const DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = exports.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = `
{
  "serviceName": "serviceName",
  "spanId": "spanId",
  "timestamp": "time",
  "traceId": "traceId"
}`;
const DEFAULT_SERVICE_MAP_MAX_NODES = exports.DEFAULT_SERVICE_MAP_MAX_NODES = 500;
const DEFAULT_SERVICE_MAP_MAX_EDGES = exports.DEFAULT_SERVICE_MAP_MAX_EDGES = 1000;
let TRACE_TABLE_TITLES = exports.TRACE_TABLE_TITLES = /*#__PURE__*/function (TRACE_TABLE_TITLES) {
  TRACE_TABLE_TITLES["all_spans"] = "All Spans";
  TRACE_TABLE_TITLES["root_spans"] = "Root Spans";
  TRACE_TABLE_TITLES["entry_spans"] = "Service Entry Spans";
  TRACE_TABLE_TITLES["traces"] = "Traces";
  return TRACE_TABLE_TITLES;
}({});
const getDescription = key => {
  const descriptions = {
    all_spans: 'Spans representing all activities in all traces across the system',
    root_spans: 'Spans marking the root or starting point of each trace',
    entry_spans: 'Spans that indicate the entry point of service-side processing',
    traces: 'Spans grouped by traceId to show a complete trace lifecycle'
  };
  return descriptions[key];
};
const TRACE_TABLE_OPTIONS = exports.TRACE_TABLE_OPTIONS = Object.entries(TRACE_TABLE_TITLES).map(([key, label]) => ({
  label,
  key,
  'aria-describedby': getDescription(key)
}));
const TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TYPE_KEY = 'TraceAnalyticsTraceTableType';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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