/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.process;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.log.LogMessage;
import com.github.kokorin.jaffree.process.StdReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblingStdReader<T>
implements StdReader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblingStdReader.class);
    private static final long REPORT_EVERY_BYTES = 1000000L;
    private static final int BUFFER_SIZE = 1014;

    @Override
    public T read(InputStream stdOut) {
        byte[] bytes = new byte[1014];
        int read = 0;
        long total = 0L;
        long lastReport = 0L;
        try {
            do {
                if ((total += (long)read) - lastReport <= 1000000L) continue;
                LOGGER.info("Read {} bytes", (Object)total);
                lastReport = total;
            } while ((read = stdOut.read(bytes)) != -1);
        }
        catch (IOException e) {
            throw new JaffreeException("Failed to read input", e);
        }
        finally {
            LOGGER.info("Totally read {} bytes", (Object)total);
        }
        return null;
    }

    @Override
    public List<LogMessage> getErrorLogMessages() {
        return Collections.emptyList();
    }
}

