/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

public class BitMap {
    int defaultCapacity;
    int capacity;
    int[] map;

    public BitMap(int n) {
        int n2 = n / 32;
        if (n % 32 != 0) {
            ++n2;
        }
        this.defaultCapacity = this.capacity = n2 * 32;
        this.map = new int[n2];
    }

    public void reset() {
        this.map = new int[this.defaultCapacity / 32];
        this.capacity = this.defaultCapacity;
    }

    public int set(int n) {
        while (n >= this.capacity) {
            this.doubleCapacity();
        }
        int n2 = n >> 5;
        int n3 = this.map[n2];
        int n4 = Integer.MIN_VALUE >>> (n & 0x1F);
        int n5 = (n3 & n4) == 0 ? 0 : 1;
        this.map[n2] = n3 | n4;
        return n5;
    }

    public int unset(int n) {
        if (n >= this.capacity) {
            return 0;
        }
        int n2 = n >> 5;
        int n3 = this.map[n2];
        int n4 = Integer.MIN_VALUE >>> (n & 0x1F);
        int n5 = (n3 & n4) == 0 ? 0 : 1;
        this.map[n2] = n3 & (n4 ^= 0xFFFFFFFF);
        return n5;
    }

    public int get(int n) {
        while (n >= this.capacity) {
            this.doubleCapacity();
        }
        int n2 = n >> 5;
        int n3 = this.map[n2];
        int n4 = Integer.MIN_VALUE >>> (n & 0x1F);
        return (n3 & n4) == 0 ? 0 : 1;
    }

    public static int set(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return n | n3;
    }

    public static int unset(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return n & (n3 ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return (n & n3) != 0;
    }

    private void doubleCapacity() {
        int[] nArray = new int[this.map.length * 2];
        this.capacity *= 2;
        System.arraycopy(this.map, 0, nArray, 0, this.map.length);
        this.map = nArray;
    }
}

