/*
Copyright 2019 The KubeOne Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

output "kubeone_api" {
  description = "kube-apiserver LB endpoint"

  value = {
    endpoint                    = nutanix_virtual_machine.lb.nic_list.0.ip_endpoint_list.0.ip
    apiserver_alternative_names = var.apiserver_alternative_names
  }
}

output "ssh_commands" {
  value = formatlist("ssh -J ${var.bastion_user}@${nutanix_virtual_machine.lb.nic_list.0.ip_endpoint_list.0.ip} ${var.ssh_username}@%s", nutanix_virtual_machine.control_plane.*.nic_list.0.ip_endpoint_list.0.ip)
}

output "kubeone_hosts" {
  description = "Control plane endpoints to SSH to"

  value = {
    control_plane = {
      cluster_name         = var.cluster_name
      cloud_provider       = "nutanix"
      private_address      = nutanix_virtual_machine.control_plane.*.nic_list.0.ip_endpoint_list.0.ip
      ssh_agent_socket     = var.ssh_agent_socket
      ssh_port             = var.ssh_port
      ssh_private_key_file = var.ssh_private_key_file
      ssh_user             = var.ssh_username
      bastion              = nutanix_virtual_machine.lb.nic_list.0.ip_endpoint_list.0.ip
      bastion_port         = var.bastion_port
      bastion_user         = var.bastion_user
      ssh_hosts_keys       = var.ssh_hosts_keys
      bastion_host_key     = var.bastion_host_key
      # kubelet            = {
      #   system_reserved                 = "cpu=200m,memory=200Mi"
      #   kube_reserved                   = "cpu=200m,memory=300Mi"
      #   eviction_hard                   = ""
      #   max_pods                        = 110
      #   image_gc_high_threshold_percent = 85
      #   image_gc_low_threshold_percent  = 80
      #   image_minimum_gc_age            = "2m"
      #   image_maximum_gc_age            = "0"
      # }
    }
  }
}

output "kubeone_workers" {
  description = "Workers definitions, that will be transformed into MachineDeployment object"

  value = {
    # following outputs will be parsed by kubeone and automatically merged into
    # corresponding (by name) worker definition
    "${var.cluster_name}-pool1" = {
      replicas = var.initial_machinedeployment_replicas
      providerSpec = {
        annotations = {
          "k8c.io/operating-system-profile"                           = var.initial_machinedeployment_operating_system_profile
          "cluster.k8s.io/cluster-api-autoscaler-node-group-min-size" = tostring(local.cluster_autoscaler_min_replicas)
          "cluster.k8s.io/cluster-api-autoscaler-node-group-max-size" = tostring(local.cluster_autoscaler_max_replicas)
        }
        sshPublicKeys   = [file(var.ssh_public_key_file)]
        operatingSystem = var.worker_os
        operatingSystemSpec = {
          distUpgradeOnBoot = false
        }
        # nodeAnnotations are applied on resulting Node objects
        # nodeAnnotations = {
        #   "key" = "value"
        # }
        # machineObjectAnnotations are applied on resulting Machine objects
        # uncomment to following to set those kubelet parameters. More into at:
        # https://kubernetes.io/docs/tasks/administer-cluster/reserve-compute-resources/
        # machineObjectAnnotations = {
        #   "v1.kubelet-config.machine-controller.kubermatic.io/SystemReserved"              = "cpu=200m,memory=200Mi"
        #   "v1.kubelet-config.machine-controller.kubermatic.io/KubeReserved"                = "cpu=200m,memory=300Mi"
        #   "v1.kubelet-config.machine-controller.kubermatic.io/EvictionHard"                = ""
        #   "v1.kubelet-config.machine-controller.kubermatic.io/MaxPods"                     = "110"
        #   "v1.kubelet-config.machine-controller.kubermatic.io/ImageGCHighThresholdPercent" = "85"
        #   "v1.kubelet-config.machine-controller.kubermatic.io/ImageGCLowThresholdPercent"  = "80"
        #   "v1.kubelet-config.machine-controller.kubermatic.io/ImageMinimumGCAge"           = "2m"
        #   "v1.kubelet-config.machine-controller.kubermatic.io/ImageMaximumGCAge"           = "0"
        # }
        cloudProviderSpec = {
          # provider specific fields:
          # see example under `cloudProviderSpec` section at:
          # https://github.com/kubermatic/machine-controller/blob/main/examples/nutanix-machinedeployment.yaml
          clusterName = var.nutanix_cluster_name
          projectName = var.project_name
          subnetName  = var.subnet_name
          imageName   = var.image_name
          cpus        = var.worker_sockets
          cpuCores    = var.worker_vcpus
          memoryMB    = var.worker_memory_size
          diskSize    = var.worker_disk_size
          categories = {
            "KubeOneCluster" = var.cluster_name
          }
        }
      }
    }
  }
}
