/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.io;

import java.io.IOException;
import org.jetbrains.kotlin.org.apache.http.HttpException;
import org.jetbrains.kotlin.org.apache.http.HttpResponse;
import org.jetbrains.kotlin.org.apache.http.HttpResponseFactory;
import org.jetbrains.kotlin.org.apache.http.NoHttpResponseException;
import org.jetbrains.kotlin.org.apache.http.ParseException;
import org.jetbrains.kotlin.org.apache.http.StatusLine;
import org.jetbrains.kotlin.org.apache.http.config.MessageConstraints;
import org.jetbrains.kotlin.org.apache.http.impl.DefaultHttpResponseFactory;
import org.jetbrains.kotlin.org.apache.http.impl.io.AbstractMessageParser;
import org.jetbrains.kotlin.org.apache.http.io.SessionInputBuffer;
import org.jetbrains.kotlin.org.apache.http.message.LineParser;
import org.jetbrains.kotlin.org.apache.http.message.ParserCursor;
import org.jetbrains.kotlin.org.apache.http.util.CharArrayBuffer;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int readLen = sessionBuffer.readLine(this.lineBuf);
        if (readLen == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

