/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.quarkus.jackson.ObjectMapperCustomizer;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class GeneratedSerializersRegister
implements ObjectMapperCustomizer {
    private static final SimpleModule mappingModule = new SimpleModule();
    private static final ExactSerializers serializers = new ExactSerializers();

    public void customize(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)mappingModule);
    }

    public static void addSerializer(Class<? extends StdSerializer> serClass) {
        try {
            StdSerializer serializer = serClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            serializers.addExactSerializer(serializer.handledType(), serializer);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addDeserializer(Class<? extends StdDeserializer> deserClass) {
        try {
            StdDeserializer deserializer = deserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            mappingModule.addDeserializer(deserializer.handledType(), (JsonDeserializer)deserializer);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mappingModule.setSerializers((SimpleSerializers)serializers);
    }

    public static class ExactSerializers
    extends SimpleSerializers {
        private final Map<Class<?>, JsonSerializer<?>> exactSerializers = new HashMap();

        public <T> void addExactSerializer(Class<? extends T> type, JsonSerializer<T> ser) {
            this.exactSerializers.put(type, ser);
        }

        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            JsonSerializer exactSerializer = this.exactSerializers.get(type.getRawClass());
            return exactSerializer != null ? exactSerializer : super.findSerializer(config, type, beanDesc);
        }
    }
}

