/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.updater.jetty;

import java.io.File;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferEventSupport;
import org.apache.maven.wagon.events.TransferListener;
import org.sonatype.nexus.index.updater.jetty.JettyTransferEvent;

class TransferListenerSupport {
    TransferEventSupport transferEventSupport = new TransferEventSupport();

    TransferListenerSupport() {
    }

    public void addTransferListener(TransferListener listener) {
        this.transferEventSupport.addTransferListener(listener);
    }

    void fireTransferError(String url, Exception e, int requestType) {
        JettyTransferEvent transferEvent = new JettyTransferEvent(url, e, requestType);
        this.transferEventSupport.fireTransferError((TransferEvent)transferEvent);
    }

    void fireTransferProgress(TransferEvent transferEvent, byte[] buffer, int n) {
        this.transferEventSupport.fireTransferProgress(transferEvent, buffer, n);
    }

    void fireGetCompleted(String url, File localFile) {
        long timestamp = System.currentTimeMillis();
        JettyTransferEvent transferEvent = new JettyTransferEvent(url, 2, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferCompleted((TransferEvent)transferEvent);
    }

    void fireGetStarted(String url, File localFile) {
        long timestamp = System.currentTimeMillis();
        JettyTransferEvent transferEvent = new JettyTransferEvent(url, 1, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferStarted((TransferEvent)transferEvent);
    }

    void fireGetInitiated(String url, File localFile) {
        long timestamp = System.currentTimeMillis();
        JettyTransferEvent transferEvent = new JettyTransferEvent(url, 0, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferInitiated((TransferEvent)transferEvent);
    }

    public void fireDebug(String message) {
        this.transferEventSupport.fireDebug(message);
    }
}

