/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.actions;

import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.views.DirectoryHistoryDialog;
import com.intellij.history.integration.ui.views.FileHistoryDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.platform.lvcs.impl.ui.ActivityView;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0000\u001a&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0000\u00a8\u0006\u000f"}, d2={"isFileVersioned", "", "gw", "Lcom/intellij/history/integration/IdeaGateway;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canShowLocalHistoryFor", "files", "", "showLocalHistoryFor", "", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "selectedFiles", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nShowLocalHistoryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowLocalHistoryUtil.kt\ncom/intellij/history/integration/ui/actions/ShowLocalHistoryUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1761#2,3:46\n774#2:49\n865#2,2:50\n*S KotlinDebug\n*F\n+ 1 ShowLocalHistoryUtil.kt\ncom/intellij/history/integration/ui/actions/ShowLocalHistoryUtilKt\n*L\n22#1:46,3\n26#1:49\n26#1:50,2\n*E\n"})
public final class ShowLocalHistoryUtilKt {
    public static final boolean isFileVersioned(@NotNull IdeaGateway gw, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)gw, (String)"gw");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return gw.isVersioned(file) && (file.isDirectory() || gw.areContentChangesVersioned(file));
    }

    public static final boolean canShowLocalHistoryFor(@NotNull IdeaGateway gw, @NotNull Collection<? extends VirtualFile> files) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)gw, (String)"gw");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            if (files.size() > 1 && !ActivityView.Companion.isViewEnabled()) {
                return false;
            }
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile file = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!ShowLocalHistoryUtilKt.isFileVersioned(gw, file)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final void showLocalHistoryFor(@NotNull Project project, @NotNull IdeaGateway gateway, @NotNull Collection<? extends VirtualFile> selectedFiles) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter(selectedFiles, (String)"selectedFiles");
        Iterable $this$filter$iv = selectedFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!ShowLocalHistoryUtilKt.isFileVersioned(gateway, file)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enabledFiles = (List)destination$iv$iv;
        if (enabledFiles.isEmpty()) {
            return;
        }
        if (ActivityView.Companion.isViewEnabled()) {
            ActivityView.Companion.showInDialog(project, gateway, ActivityScope.Companion.fromFiles(enabledFiles));
            return;
        }
        VirtualFile singleFile = (VirtualFile)ContainerUtil.getOnlyItem((Collection)enabledFiles);
        if (singleFile == null) {
            return;
        }
        if (singleFile.isDirectory()) {
            LocalHistoryCounter.INSTANCE.logLocalHistoryOpened(LocalHistoryCounter.Kind.Directory);
            new DirectoryHistoryDialog(project, gateway, singleFile).show();
        } else {
            LocalHistoryCounter.INSTANCE.logLocalHistoryOpened(LocalHistoryCounter.Kind.File);
            new FileHistoryDialog(project, gateway, singleFile).show();
        }
    }
}

