/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bJ(\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\t2\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bH\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0010\u001a \u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f\u0012\u0004\u0012\u00020\f0\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/utils/EmptinessCheckFunctionUtils;", "", "<init>", "()V", "invertFunctionCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "functionFqName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/name/FqName;", "invertedFunctionName", "", "callExpression", "packages", "", "functionNames", "", "Lkotlin/Pair;", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nEmptinessCheckFunctionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmptinessCheckFunctionUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/EmptinessCheckFunctionUtils\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 KaCallInfo.kt\norg/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n30#2,2:71\n35#3,9:73\n48#3,2:83\n45#3,2:85\n95#4:82\n1563#5:87\n1634#5,3:88\n1563#5:91\n1634#5,3:92\n*S KotlinDebug\n*F\n+ 1 EmptinessCheckFunctionUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/EmptinessCheckFunctionUtils\n*L\n14#1:71,2\n14#1:73,9\n14#1:83,2\n14#1:85,2\n15#1:82\n64#1:87\n64#1:88,3\n65#1:91\n65#1:92,3\n*E\n"})
public final class EmptinessCheckFunctionUtils {
    @NotNull
    public static final EmptinessCheckFunctionUtils INSTANCE;
    @NotNull
    private static final List<String> packages;
    @NotNull
    private static final Map<String, Pair<List<FqName>, String>> functionNames;

    private EmptinessCheckFunctionUtils() {
    }

    @Nullable
    public final KtExpression invertFunctionCall(@NotNull KtExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.invertFunctionCall(expression, (Function1<? super KtCallExpression, FqName>)((Function1)EmptinessCheckFunctionUtils::invertFunctionCall$lambda$1));
    }

    @Nullable
    public final KtExpression invertFunctionCall(@NotNull KtExpression expression, @NotNull Function1<? super KtCallExpression, FqName> functionFqName) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(functionFqName, (String)"functionFqName");
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtExpression ktExpression2 = expression;
        if (ktExpression2 instanceof KtCallExpression) {
            String string = this.invertedFunctionName((KtCallExpression)expression, functionFqName);
            if (string == null) {
                return null;
            }
            String inverted = string;
            ktExpression = psiFactory.createExpression(inverted + "()");
        } else if (ktExpression2 instanceof KtQualifiedExpression) {
            KtCallExpression ktCallExpression = KotlinPsiUtilsKt.getCallExpression((KtQualifiedExpression)expression);
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression call2 = ktCallExpression;
            String string = this.invertedFunctionName(call2, functionFqName);
            if (string == null) {
                return null;
            }
            String inverted = string;
            Object[] objectArray = new Object[]{((KtQualifiedExpression)expression).getReceiverExpression()};
            ktExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)psiFactory, (String)("$0." + inverted + "()"), (Object[])objectArray, (boolean)false);
        } else {
            return null;
        }
        KtExpression inverted = ktExpression;
        return inverted;
    }

    private final String invertedFunctionName(KtCallExpression callExpression, Function1<? super KtCallExpression, FqName> functionFqName) {
        Object object = callExpression.getCalleeExpression();
        if (object == null || (object = object.getText()) == null) {
            return null;
        }
        Object fromFunctionName = object;
        Pair<List<FqName>, String> pair = functionNames.get(fromFunctionName);
        if (pair == null) {
            return null;
        }
        Pair<List<FqName>, String> pair2 = pair;
        List fromFunctionFqNames = (List)pair2.component1();
        String toFunctionName = (String)pair2.component2();
        if (!CollectionsKt.contains((Iterable)fromFunctionFqNames, (Object)functionFqName.invoke((Object)callExpression))) {
            return null;
        }
        return toFunctionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final FqName invertFunctionCall$lambda$1(KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        useSiteElement$iv = (KtElement)it;
        $i$f$analyze = false;
        v0 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
        var3_3 = KaSessionProvider.Companion.getInstance(v0);
        useSiteElement$iv$iv = useSiteElement$iv;
        $i$f$analyze = false;
        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            var8_8 = lock$iv$iv = new Object();
            synchronized (var8_8) {
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                $this$invertFunctionCall_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv;
                $i$a$-analyze-EmptinessCheckFunctionUtils$invertFunctionCall$1$1 = false;
                v1 /* !! */  = $this$invertFunctionCall_u24lambda_u241_u24lambda_u240.resolveToCall((KtElement)it);
                if (v1 /* !! */  == null) ** GOTO lbl-1000
                $this$successfulCallOrNull$iv = v1 /* !! */ ;
                $i$f$successfulCallOrNull = false;
                v2 = $this$successfulCallOrNull$iv instanceof KaSuccessCallInfo != false ? (KaSuccessCallInfo)$this$successfulCallOrNull$iv : null;
                v3 = v2 != null ? v2.getCall() : null;
                if (!(v3 instanceof KaCallableMemberCall)) {
                    v3 = null;
                }
                if ((v1 /* !! */  = (KaCallableMemberCall)((KaCall)((KaCallableMemberCall)v3))) != null) {
                    v4 /* !! */  = KaCallKt.getSymbol(v1 /* !! */ );
                } else lbl-1000:
                // 2 sources

                {
                    v4 /* !! */  = null;
                }
                var9_12 = (v5 = (symbol = v4 /* !! */ )) != null && (v5 = v5.getCallableId()) != null ? v5.asSingleFqName() : null;
            }
            var7_7 = var9_12;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        return var7_7;
    }

    static {
        String it;
        Collection<FqName> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        INSTANCE = new EmptinessCheckFunctionUtils();
        Object[] objectArray = new String[]{"java.util.ArrayList", "java.util.HashMap", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "kotlin.collections", "kotlin.collections.List", "kotlin.collections.Set", "kotlin.collections.Map", "kotlin.collections.MutableList", "kotlin.collections.MutableSet", "kotlin.collections.MutableMap", "kotlin.text"};
        packages = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[4];
        Iterable iterable = packages;
        String string = "isEmpty";
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(it + ".isEmpty"));
        }
        collection = (List)destination$iv$iv;
        String string3 = "isNotEmpty";
        Collection<FqName> collection2 = collection;
        objectArray2[n] = TuplesKt.to((Object)string, (Object)new Pair((Object)collection2, (Object)string3));
        $this$map$iv = packages;
        string = "isNotEmpty";
        n = 1;
        objectArray2 = objectArray;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(it + ".isNotEmpty"));
        }
        collection = (List)destination$iv$iv;
        String string4 = "isEmpty";
        Collection<FqName> collection3 = collection;
        objectArray2[n] = TuplesKt.to((Object)string, (Object)new Pair(collection3, (Object)string4));
        objectArray[2] = TuplesKt.to((Object)"isBlank", (Object)new Pair((Object)CollectionsKt.listOf((Object)new FqName("kotlin.text.isBlank")), (Object)"isNotBlank"));
        objectArray[3] = TuplesKt.to((Object)"isNotBlank", (Object)new Pair((Object)CollectionsKt.listOf((Object)new FqName("kotlin.text.isNotBlank")), (Object)"isBlank"));
        functionNames = MapsKt.mapOf((Pair[])objectArray);
    }
}

