/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.internal.statistic.devkit.actions.OpenEventsSchemeFileAction;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogFilter;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogFormatter;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ0\u0010\u0010\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012\u0018\u0001`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogConsole;", "Lcom/intellij/diagnostic/logging/LogConsoleBase;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/diagnostic/logging/LogFilterModel;", "recorderId", "", "logFormatter", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogFormatter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diagnostic/logging/LogFilterModel;Ljava/lang/String;Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogFormatter;)V", "getLogFormatter", "()Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogFormatter;", "isMultilineLog", "", "computeLineNumbers", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "schemeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isActive", "addLogLine", "", "line", "updateLogPresentation", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogConsole
extends LogConsoleBase {
    @NotNull
    private final Project project;
    @NotNull
    private final StatisticsEventLogFormatter logFormatter;
    private boolean isMultilineLog;

    public StatisticsEventLogConsole(@NotNull Project project, @NotNull LogFilterModel model, @NotNull String recorderId, @NotNull StatisticsEventLogFormatter logFormatter) {
        block1: {
            HashMap groupIdToLine;
            Map map2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            Intrinsics.checkNotNullParameter((Object)((Object)logFormatter), (String)"logFormatter");
            super(project, null, "Statistics Event Log", false, model, GlobalSearchScope.allScope((Project)project), (LogFormatter)logFormatter);
            this.project = project;
            this.logFormatter = logFormatter;
            VirtualFile schemeFile = LocalFileSystem.getInstance().findFileByNioFile(OpenEventsSchemeFileAction.Manager.INSTANCE.getEventsSchemeFile(recorderId));
            if (schemeFile == null || (map2 = (Map)(groupIdToLine = (HashMap)ReadAction.compute(() -> StatisticsEventLogConsole._init_$lambda$0(this, schemeFile)))) == null || map2.isEmpty()) break block1;
            ConsoleView consoleView = this.getConsole();
            if (consoleView != null) {
                consoleView.addMessageFilter((Filter)new StatisticsEventLogFilter(schemeFile, groupIdToLine));
            }
        }
    }

    @NotNull
    public final StatisticsEventLogFormatter getLogFormatter() {
        return this.logFormatter;
    }

    private final HashMap<String, Integer> computeLineNumbers(VirtualFile schemeFile) {
        HashMap<String, Integer> groupIdToLine = new HashMap<String, Integer>();
        Document document = FileDocumentManager.getInstance().getDocument(schemeFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(schemeFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)JsonLanguage.INSTANCE)) {
            psiFile2.accept((PsiElementVisitor)new JsonRecursiveElementVisitor(groupIdToLine, document2){
                final /* synthetic */ HashMap<String, Integer> $groupIdToLine;
                final /* synthetic */ Document $document;
                {
                    this.$groupIdToLine = $groupIdToLine;
                    this.$document = $document;
                }

                public void visitProperty(JsonProperty property) {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    if (!Intrinsics.areEqual((Object)property.getName(), (Object)"groups")) {
                        return;
                    }
                    JsonValue jsonValue = property.getValue();
                    JsonArray jsonArray = jsonValue instanceof JsonArray ? (JsonArray)jsonValue : null;
                    if (jsonArray == null) {
                        return;
                    }
                    JsonArray groups = jsonArray;
                    for (JsonValue groupElement : groups.getValueList()) {
                        JsonProperty idProperty;
                        JsonValue jsonValue2;
                        Object object;
                        Intrinsics.checkNotNull((Object)groupElement, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
                        JsonObject groupObject = (JsonObject)groupElement;
                        if (groupObject.findProperty("id") == null || (object = (jsonValue2 = idProperty.getValue()) instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue2 : null) == null || (object = object.getValue()) == null) continue;
                        Object id = object;
                        ((Map)this.$groupIdToLine).put(id, this.$document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)idProperty))));
                    }
                }
            });
        }
        return groupIdToLine;
    }

    public boolean isActive() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Statistics Event Log");
        return toolWindow != null ? toolWindow.isVisible() : false;
    }

    public final void addLogLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        super.addMessage(line);
    }

    public final void updateLogPresentation(boolean isMultilineLog) {
        this.isMultilineLog = isMultilineLog;
        this.logFormatter.updateLogPresentation(isMultilineLog);
        this.filterConsoleOutput();
    }

    private static final HashMap _init_$lambda$0(StatisticsEventLogConsole this$0, VirtualFile $schemeFile) {
        return this$0.computeLineNumbers($schemeFile);
    }
}

