---
stage: none
group: none
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 依存関係をデプロイして管理します。
title: アプリケーションのデプロイとリリースを始める
---

まず、アプリケーションをプレビューし、最終的にユーザー向けに本番環境にデプロイします。コンテナやパッケージを管理し、継続的インテグレーションを使用してアプリケーションをデリバリーします。機能フラグと段階的ロールアウトを使用して、制御された方法でアプリケーションをリリースします。

これらのプロセスは、以下に示すより大きなワークフローの一部です。

![GitLabで行う主な作業の図で、「アプリケーションのデプロイとリリース」セクションが強調表示されています。](img/get_started_release_v16_11.png)

## ステップ1: プロジェクトのアーティファクトを保存してアクセスする {#step-1-store-and-access-your-projects-artifacts}

パッケージとレジストリを使用して、プロジェクトの依存関係、ライブラリ、その他のアーティファクトを安全にGitLabに保存および配布します。

パッケージレジストリは、Maven、NPM、NuGet、PyPI、Conanなど、さまざまなパッケージ形式をサポートしています。複数のプロジェクトにわたってパッケージを保存および配布するための一元化された場所を提供します。パッケージレジストリをGitLab CI/CDパイプラインと統合することで、パッケージの公開を自動化し、開発とデプロイのワークフローをスムーズに進めることができます。

コンテナレジストリは、Dockerイメージのプライベートレジストリとして機能します。これを使用して、組織内で、または一般に公開して、DockerおよびOCIイメージを保存、管理、配布できます。コンテナレジストリをGitLab CI/CDと統合することで、コンテナ化されたアプリケーションのビルド、テスト、デプロイを実行できます。

詳細については、以下を参照してください。

- [パッケージとレジストリ](../packages/_index.md)

## ステップ2: 複数の環境にわたってアプリケーションをデプロイする {#step-2-deploy-your-application-across-environments}

環境を使用して、さまざまなステージ（Development、Staging、Productionなど）にわたるアプリケーションのデプロイを管理および追跡します。各環境には、独自の設定、変数、デプロイ設定があります。

環境をセットアップしたら、それらを監視できます。主にデプロイ先（AWSなど）でデプロイを監視しますが、GitLabもダッシュボードを提供しています。Kubernetesにデプロイしている場合は、GitLab UIで稼働中のクラスターの状態を監視できます。

マージリクエストの一部として、一時的な環境を作成することもできます。その環境で、チームメンバーはmainブランチへの変更をコミットする前に、変更のレビューやテストを行えます。このような一時的な環境は、レビューアプリと呼ばれます。

詳細については、以下を参照してください。

- [環境](../../ci/environments/_index.md)
- [AWSへデプロイする](../../ci/cloud_deployment/_index.md)
- [Kubernetesへデプロイする](../clusters/agent/_index.md)
- [Kubernetes向けダッシュボード](../../ci/environments/kubernetes_dashboard.md)
- [環境ダッシュボード](../../ci/environments/environments_dashboard.md)
- [運用ダッシュボード](../operations_dashboard/_index.md)
- [レビューアプリ](../../ci/review_apps/_index.md)

## ステップ3: 継続的デリバリー機能でコンプライアンスを維持する {#step-3-stay-compliant-with-continuous-delivery-features}

偶発的または不正なデプロイを防ぐことで、本番環境システムの安定性と整合性を維持するには、保護環境を使用します。保護環境は、本番環境などの重要な環境へのデプロイを保護および制御する方法を提供します。保護環境を定義することで、特定のユーザーまたはロールへのアクセスを制限し、承認されたユーザーのみが変更をデプロイできるようにすることができます。

デプロイプロセスの安全性は継続的デリバリーパイプラインの一環として、デプロイの信頼性とセキュリティを確保するのに役立ちます。GitLabには、デプロイ失敗時の自動ロールバックや、デプロイの成功を確認するためのカスタムヘルスチェックを定義できる機能など、組み込みの安全メカニズムが用意されています。

デプロイの承認により、デプロイプロセスの制御とコラボレーションが強化されます。指定された承認者がデプロイをレビューして承認するまで進行できないようにする承認ルールを定義できます。承認は、環境、ブランチ、またはデプロイ対象の特定の変更内容など、さまざまな条件に基づいて設定できます。

詳細については、以下を参照してください。

- [保護環境](../../ci/environments/protected_environments.md)
- [デプロイの安全性](../../ci/environments/deployment_safety.md)
- [デプロイの承認](../../ci/environments/deployment_approvals.md)

## ステップ4: リリースアーティファクトを一般または内部ユーザーに配布する {#step-4-ship-release-artifacts-to-the-public-or-internal-users}

リリースを使用して、リリースノート、バイナリアセット、その他の関連情報を含むアプリケーションをパッケージ化し、エンドユーザーに配布します。リリースは任意のブランチから作成できます。

リリースと環境を統合することで、特定の環境（たとえば本番環境）にデプロイするたびにリリースを自動的に作成できます。リリースが発生するたびに通知を受け取ることができます。また、リリースの作成、更新、削除を行えるユーザーを制御する場合は、対応する権限を指定できます。

詳細については、以下を参照してください。

- [リリース](../project/releases/_index.md)

## ステップ5: 変更を安全にロールアウトする {#step-5-roll-out-changes-safely}

アプリケーションを一部のユーザーまたはサーバーに段階的にデプロイするには、段階的ロールアウトを使用します。ユーザーベース全体にロールアウトする前に、小規模な範囲で影響を監視および評価できます。

GitLabの機能フラグは、完全なデプロイを必要とせず、アプリケーションの特定の機能を有効または無効にする方法を提供します。機能フラグを使用することで、新機能を安全にテストしたり、A/Bテストを実施したり、変更を段階的にユーザーに導入したりできます。

また、機能フラグにより、コードのデプロイを機能のリリースから切り離し、ユーザーエクスペリエンスをより細かく制御しながら、バグや予期しない動作が発生するリスクを軽減できます。

詳細については、以下を参照してください。

- [段階的なロールアウト](../../ci/environments/incremental_rollouts.md)
- [機能フラグ](../../operations/feature_flags.md)

## ステップ6: 静的ウェブサイトをデプロイする {#step-6-deploy-a-static-website}

GitLab Pagesを使用すると、プロジェクトのドキュメント、デモ、マーケティングページなどを公開できます。GitLab内のリポジトリから直接、静的ウェブサイトを作成できます。GitLab Pagesは、Jekyll、Hugo、Middlemanなどの静的サイトジェネレーターのほか、プレーンなHTML、CSS、JavaScriptをサポートしています。作成を開始するには、新しいプロジェクトを作成するか、既存のプロジェクトを使用し、GitLab Pagesの設定を行ってコンテンツをリポジトリにプッシュします。指定したブランチに変更をプッシュするたびに、GitLabは自動的にウェブサイトをビルドしてデプロイします。

詳細については、以下を参照してください。

- [GitLab Pages](../project/pages/_index.md)

## ステップ7: Auto Deployで推奨設定を使用する {#step-7-go-opinionated-with-auto-deploy}

Auto Deployは特に、アプリケーションのビルドとデプロイを自動的に処理するために推奨されるCIテンプレートです。環境変数を使用して、Auto DevOpsパイプラインを微調整できます。

詳細については、以下を参照してください。

- [Auto Deploy](../../topics/autodevops/stages.md#auto-deploy)
