/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.part.EditorActionBarContributor;

public abstract class ActionBarContributor
extends EditorActionBarContributor {
    private ActionRegistry registry = new ActionRegistry();
    private List<RetargetAction> retargetActions = new ArrayList<RetargetAction>();
    private final List<String> globalActionKeys = new ArrayList<String>();

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addGlobalActionKey(String key) {
        this.globalActionKeys.add(key);
    }

    protected void addRetargetAction(RetargetAction action) {
        this.addAction((IAction)action);
        this.retargetActions.add(action);
        this.getPage().addPartListener((IPartListener)action);
        this.addGlobalActionKey(action.getId());
    }

    protected abstract void buildActions();

    protected abstract void declareGlobalActionKeys();

    public void dispose() {
        for (RetargetAction retargetAction : this.retargetActions) {
            this.getPage().removePartListener((IPartListener)retargetAction);
            retargetAction.dispose();
        }
        this.registry.dispose();
        this.retargetActions = null;
        this.registry = null;
    }

    protected IAction getAction(String id) {
        return this.getActionRegistry().getAction(id);
    }

    protected ActionRegistry getActionRegistry() {
        return this.registry;
    }

    public void init(IActionBars bars) {
        this.buildActions();
        this.declareGlobalActionKeys();
        super.init(bars);
    }

    public void setActiveEditor(IEditorPart editor) {
        ActionRegistry editorRegistry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
        IActionBars bars = this.getActionBars();
        for (String id : this.globalActionKeys) {
            IAction handler = editorRegistry != null ? editorRegistry.getAction(id) : null;
            bars.setGlobalActionHandler(id, handler);
        }
    }
}

