/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Rate;

final class ModelUtility {
    ModelUtility() {
    }

    public static boolean isFieldPopulated(FieldType field, Object value) {
        boolean populated;
        if (value == null) {
            return false;
        }
        switch (field.getDataType()) {
            case STRING: {
                populated = !((String)value).isEmpty();
                break;
            }
            case NUMERIC: 
            case CURRENCY: {
                populated = ((Number)value).doubleValue() != 0.0;
                break;
            }
            case DURATION: 
            case WORK: {
                populated = value instanceof Duration && ((Duration)value).getDuration() != 0.0;
                break;
            }
            case RATE: {
                populated = ((Rate)value).getAmount() != 0.0;
                break;
            }
            case BOOLEAN: {
                populated = (Boolean)value;
                break;
            }
            default: {
                populated = true;
            }
        }
        return populated;
    }
}

