﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/rds/RDS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace RDS {
namespace Model {

/**
 * <p>Option settings are the actual settings being applied or configured for that
 * option. It is used when you modify an option group or describe option groups.
 * For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called
 * SQLNET.ENCRYPTION_SERVER that can have several different values.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionSetting">AWS
 * API Reference</a></p>
 */
class OptionSetting {
 public:
  AWS_RDS_API OptionSetting() = default;
  AWS_RDS_API OptionSetting(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_RDS_API OptionSetting& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_RDS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_RDS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The name of the option that has settings that you can set.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  OptionSetting& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current value of the option setting.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  OptionSetting& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The default value of the option setting.</p>
   */
  inline const Aws::String& GetDefaultValue() const { return m_defaultValue; }
  inline bool DefaultValueHasBeenSet() const { return m_defaultValueHasBeenSet; }
  template <typename DefaultValueT = Aws::String>
  void SetDefaultValue(DefaultValueT&& value) {
    m_defaultValueHasBeenSet = true;
    m_defaultValue = std::forward<DefaultValueT>(value);
  }
  template <typename DefaultValueT = Aws::String>
  OptionSetting& WithDefaultValue(DefaultValueT&& value) {
    SetDefaultValue(std::forward<DefaultValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the option setting.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  OptionSetting& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The DB engine specific parameter type.</p>
   */
  inline const Aws::String& GetApplyType() const { return m_applyType; }
  inline bool ApplyTypeHasBeenSet() const { return m_applyTypeHasBeenSet; }
  template <typename ApplyTypeT = Aws::String>
  void SetApplyType(ApplyTypeT&& value) {
    m_applyTypeHasBeenSet = true;
    m_applyType = std::forward<ApplyTypeT>(value);
  }
  template <typename ApplyTypeT = Aws::String>
  OptionSetting& WithApplyType(ApplyTypeT&& value) {
    SetApplyType(std::forward<ApplyTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data type of the option setting.</p>
   */
  inline const Aws::String& GetDataType() const { return m_dataType; }
  inline bool DataTypeHasBeenSet() const { return m_dataTypeHasBeenSet; }
  template <typename DataTypeT = Aws::String>
  void SetDataType(DataTypeT&& value) {
    m_dataTypeHasBeenSet = true;
    m_dataType = std::forward<DataTypeT>(value);
  }
  template <typename DataTypeT = Aws::String>
  OptionSetting& WithDataType(DataTypeT&& value) {
    SetDataType(std::forward<DataTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The allowed values of the option setting.</p>
   */
  inline const Aws::String& GetAllowedValues() const { return m_allowedValues; }
  inline bool AllowedValuesHasBeenSet() const { return m_allowedValuesHasBeenSet; }
  template <typename AllowedValuesT = Aws::String>
  void SetAllowedValues(AllowedValuesT&& value) {
    m_allowedValuesHasBeenSet = true;
    m_allowedValues = std::forward<AllowedValuesT>(value);
  }
  template <typename AllowedValuesT = Aws::String>
  OptionSetting& WithAllowedValues(AllowedValuesT&& value) {
    SetAllowedValues(std::forward<AllowedValuesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether the option setting can be modified from the default.</p>
   */
  inline bool GetIsModifiable() const { return m_isModifiable; }
  inline bool IsModifiableHasBeenSet() const { return m_isModifiableHasBeenSet; }
  inline void SetIsModifiable(bool value) {
    m_isModifiableHasBeenSet = true;
    m_isModifiable = value;
  }
  inline OptionSetting& WithIsModifiable(bool value) {
    SetIsModifiable(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether the option setting is part of a collection.</p>
   */
  inline bool GetIsCollection() const { return m_isCollection; }
  inline bool IsCollectionHasBeenSet() const { return m_isCollectionHasBeenSet; }
  inline void SetIsCollection(bool value) {
    m_isCollectionHasBeenSet = true;
    m_isCollection = value;
  }
  inline OptionSetting& WithIsCollection(bool value) {
    SetIsCollection(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_value;

  Aws::String m_defaultValue;

  Aws::String m_description;

  Aws::String m_applyType;

  Aws::String m_dataType;

  Aws::String m_allowedValues;

  bool m_isModifiable{false};

  bool m_isCollection{false};
  bool m_nameHasBeenSet = false;
  bool m_valueHasBeenSet = false;
  bool m_defaultValueHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_applyTypeHasBeenSet = false;
  bool m_dataTypeHasBeenSet = false;
  bool m_allowedValuesHasBeenSet = false;
  bool m_isModifiableHasBeenSet = false;
  bool m_isCollectionHasBeenSet = false;
};

}  // namespace Model
}  // namespace RDS
}  // namespace Aws
