﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/datazone/DataZone_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DataZone {
namespace Model {

/**
 * <p>The details of a metadata form.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/FormInput">AWS
 * API Reference</a></p>
 */
class FormInput {
 public:
  AWS_DATAZONE_API FormInput() = default;
  AWS_DATAZONE_API FormInput(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API FormInput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the metadata form.</p>
   */
  inline const Aws::String& GetFormName() const { return m_formName; }
  inline bool FormNameHasBeenSet() const { return m_formNameHasBeenSet; }
  template <typename FormNameT = Aws::String>
  void SetFormName(FormNameT&& value) {
    m_formNameHasBeenSet = true;
    m_formName = std::forward<FormNameT>(value);
  }
  template <typename FormNameT = Aws::String>
  FormInput& WithFormName(FormNameT&& value) {
    SetFormName(std::forward<FormNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the metadata form type.</p>
   */
  inline const Aws::String& GetTypeIdentifier() const { return m_typeIdentifier; }
  inline bool TypeIdentifierHasBeenSet() const { return m_typeIdentifierHasBeenSet; }
  template <typename TypeIdentifierT = Aws::String>
  void SetTypeIdentifier(TypeIdentifierT&& value) {
    m_typeIdentifierHasBeenSet = true;
    m_typeIdentifier = std::forward<TypeIdentifierT>(value);
  }
  template <typename TypeIdentifierT = Aws::String>
  FormInput& WithTypeIdentifier(TypeIdentifierT&& value) {
    SetTypeIdentifier(std::forward<TypeIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The revision of the metadata form type.</p>
   */
  inline const Aws::String& GetTypeRevision() const { return m_typeRevision; }
  inline bool TypeRevisionHasBeenSet() const { return m_typeRevisionHasBeenSet; }
  template <typename TypeRevisionT = Aws::String>
  void SetTypeRevision(TypeRevisionT&& value) {
    m_typeRevisionHasBeenSet = true;
    m_typeRevision = std::forward<TypeRevisionT>(value);
  }
  template <typename TypeRevisionT = Aws::String>
  FormInput& WithTypeRevision(TypeRevisionT&& value) {
    SetTypeRevision(std::forward<TypeRevisionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The content of the metadata form.</p>
   */
  inline const Aws::String& GetContent() const { return m_content; }
  inline bool ContentHasBeenSet() const { return m_contentHasBeenSet; }
  template <typename ContentT = Aws::String>
  void SetContent(ContentT&& value) {
    m_contentHasBeenSet = true;
    m_content = std::forward<ContentT>(value);
  }
  template <typename ContentT = Aws::String>
  FormInput& WithContent(ContentT&& value) {
    SetContent(std::forward<ContentT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_formName;

  Aws::String m_typeIdentifier;

  Aws::String m_typeRevision;

  Aws::String m_content;
  bool m_formNameHasBeenSet = false;
  bool m_typeIdentifierHasBeenSet = false;
  bool m_typeRevisionHasBeenSet = false;
  bool m_contentHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataZone
}  // namespace Aws
