﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>
#include <aws/waf-regional/model/RuleGroup.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WAFRegional {
namespace Model {
class GetRuleGroupResult {
 public:
  AWS_WAFREGIONAL_API GetRuleGroupResult() = default;
  AWS_WAFREGIONAL_API GetRuleGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WAFREGIONAL_API GetRuleGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the <a>RuleGroup</a> that you specified in the
   * <code>GetRuleGroup</code> request. </p>
   */
  inline const RuleGroup& GetRuleGroup() const { return m_ruleGroup; }
  template <typename RuleGroupT = RuleGroup>
  void SetRuleGroup(RuleGroupT&& value) {
    m_ruleGroupHasBeenSet = true;
    m_ruleGroup = std::forward<RuleGroupT>(value);
  }
  template <typename RuleGroupT = RuleGroup>
  GetRuleGroupResult& WithRuleGroup(RuleGroupT&& value) {
    SetRuleGroup(std::forward<RuleGroupT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetRuleGroupResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  RuleGroup m_ruleGroup;
  bool m_ruleGroupHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFRegional
}  // namespace Aws
