/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.TrackedInputStream;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;

public abstract class AbstractResource
implements WebResource {
    protected static final StringManager sm = StringManager.getManager(AbstractResource.class);
    private final WebResourceRoot root;
    private final String webAppPath;
    private String mimeType = null;
    private volatile String weakETag;
    private volatile String strongETag;

    protected AbstractResource(WebResourceRoot webResourceRoot, String string) {
        this.root = webResourceRoot;
        this.webAppPath = string;
    }

    @Override
    public final WebResourceRoot getWebResourceRoot() {
        return this.root;
    }

    @Override
    public final String getWebappPath() {
        return this.webAppPath;
    }

    @Override
    public final String getLastModifiedHttp() {
        return FastHttpDateFormat.formatDate((long)this.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getETag() {
        if (this.weakETag == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.weakETag == null) {
                    long l = this.getContentLength();
                    long l2 = this.getLastModified();
                    if (l >= 0L || l2 >= 0L) {
                        this.weakETag = "W/\"" + l + "-" + l2 + "\"";
                    }
                }
            }
        }
        return this.weakETag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getStrongETag() {
        if (this.strongETag == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.strongETag == null) {
                    long l = this.getContentLength();
                    long l2 = this.getLastModified();
                    if (l > 0L && l2 > 0L) {
                        if (l <= 16384L) {
                            byte[] byArray = this.getContent();
                            if (byArray != null) {
                                byArray = ConcurrentMessageDigest.digestSHA256((byte[][])new byte[][]{byArray});
                                this.strongETag = "\"" + HexUtils.toHexString((byte[])byArray) + "\"";
                            } else {
                                this.strongETag = this.getETag();
                            }
                        } else {
                            byte[] byArray = new byte[4096];
                            try (InputStream inputStream = this.getInputStream();){
                                int n;
                                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                                while ((n = inputStream.read(byArray)) > 0) {
                                    messageDigest.update(byArray, 0, n);
                                }
                                this.strongETag = "\"" + HexUtils.toHexString((byte[])messageDigest.digest()) + "\"";
                            }
                            catch (Exception exception) {
                                this.strongETag = this.getETag();
                            }
                        }
                    } else {
                        this.strongETag = this.getETag();
                    }
                }
            }
        }
        return this.strongETag;
    }

    @Override
    public final void setMimeType(String string) {
        this.mimeType = string;
    }

    @Override
    public final String getMimeType() {
        String string;
        int n;
        if (this.mimeType == null && (n = (string = this.getName()).lastIndexOf(46)) > -1) {
            String string2 = string.substring(n + 1);
            this.mimeType = this.root.getContext().findMimeMapping(string2);
        }
        return this.mimeType;
    }

    @Override
    public final InputStream getInputStream() {
        InputStream inputStream = this.doGetInputStream();
        if (inputStream == null || !this.root.getTrackLockedFiles()) {
            return inputStream;
        }
        return new TrackedInputStream(this.root, this.getName(), inputStream);
    }

    protected abstract InputStream doGetInputStream();

    protected abstract Log getLog();
}

