/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.slice;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.truffle.api.CompilerAsserts;

public final class PIntSlice
extends PSlice {
    protected final int start;
    protected final int stop;
    protected final int step;
    protected final boolean startIsNone;
    protected final boolean stepIsNone;

    public PIntSlice(PythonLanguage lang, int start, int stop, int step, boolean startIsNone, boolean stepIsNone) {
        super(lang);
        this.start = startIsNone ? 0 : start;
        this.stop = stop;
        this.step = stepIsNone ? 1 : step;
        this.startIsNone = startIsNone;
        this.stepIsNone = stepIsNone;
    }

    public PIntSlice(PythonLanguage lang, int start, int stop, int step) {
        this(lang, start, stop, step, false, false);
    }

    public final int getIntStart() {
        return this.start;
    }

    @Override
    public final Object getStart() {
        return this.startIsNone ? PNone.NONE : Integer.valueOf(this.start);
    }

    public final int getIntStop() {
        return this.stop;
    }

    @Override
    public final Object getStop() {
        return this.stop;
    }

    public final int getIntStep() {
        return this.step;
    }

    public boolean isStartNone() {
        return this.startIsNone;
    }

    @Override
    public final Object getStep() {
        return this.stepIsNone ? PNone.NONE : Integer.valueOf(this.step);
    }

    public PSlice.SliceInfo computeIndices(int length) {
        return PIntSlice.computeIndices(this.getStart(), this.stop, this.getStep(), length);
    }

    public boolean equals(PIntSlice other) {
        return this.start == other.start && this.stop == other.stop && this.step == other.step && this.startIsNone == other.startIsNone && this.stepIsNone == other.stepIsNone;
    }

    @Override
    public boolean equals(Object obj) {
        CompilerAsserts.neverPartOfCompilation();
        if (obj instanceof PIntSlice) {
            return this.equals((PIntSlice)obj);
        }
        return super.equals(obj);
    }
}

