/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={PGuards.class})
public abstract class PySequenceSetItemNode
extends Node {
    public abstract void execute(Frame var1, Node var2, Object var3, int var4, Object var5);

    @Specialization(guards={"isBuiltinList(object)"}, excludeForUncached=true)
    static void doList(VirtualFrame frame, PList object, int key, Object value, @Cached(inline=false) ListBuiltins.SetItemNode setItemNode) {
        setItemNode.executeIntKey(frame, object, key, value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"doList"})
    static void doGeneric(VirtualFrame frame, Node inliningTarget, Object object, int index, Object value, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached PySequenceGetItemNode.IndexForSqSlotInt indexForSqSlot, @Cached TpSlotSqAssItem.CallSlotSqAssItemNode callSetItem, @Cached PRaiseNode raiseNode) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, object);
        index = indexForSqSlot.execute(frame, inliningTarget, object, slots, index);
        if (slots.sq_ass_item() == null) {
            throw PySequenceSetItemNode.raiseNotSupported(object, inliningTarget, raiseNode, slots);
        }
        callSetItem.execute(frame, inliningTarget, slots.sq_ass_item(), object, index, value);
    }

    @HostCompilerDirectives.InliningCutoff
    static PException raiseNotSupported(Object object, Node inliningTarget, PRaiseNode raiseNode, TpSlots slots) {
        TruffleString message = ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT;
        if (slots.mp_subscript() != null) {
            message = ErrorMessages.IS_NOT_A_SEQUENCE;
        }
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, message, object);
    }
}

