/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.offline;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.formatter.serialize.CatalogSerializationUtility;
import schemacrawler.tools.offline.jdbc.OfflineConnection;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.property.PropertyName;

public final class OfflineCatalogLoader
extends BaseCatalogLoader {
    private static final Logger LOGGER = Logger.getLogger(OfflineCatalogLoader.class.getName());

    public OfflineCatalogLoader() {
        super(new PropertyName("offlineloader", "Loader for offline databases"), -1);
    }

    public void loadCatalog() {
        Catalog catalog;
        if (this.isLoaded()) {
            return;
        }
        try (Connection connection = (Connection)this.getDataSource().get();){
            boolean isOfflineConnection;
            if (connection == null) {
                return;
            }
            boolean bl = isOfflineConnection = connection instanceof OfflineConnection || connection.isWrapperFor(OfflineConnection.class);
            if (!isOfflineConnection) {
                return;
            }
            OfflineConnection dbConnection = connection.isWrapperFor(OfflineConnection.class) ? connection.unwrap(OfflineConnection.class) : (OfflineConnection)connection;
            Path offlineDatabasePath = dbConnection.getOfflineDatabasePath();
            catalog = CatalogSerializationUtility.deserializeCatalog((Path)offlineDatabasePath);
            SchemaCrawlerOptions schemaCrawlerOptions = this.getSchemaCrawlerOptions();
            MetaDataUtility.reduceCatalog((Catalog)catalog, (SchemaCrawlerOptions)schemaCrawlerOptions);
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not load offline database", e);
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Could not load offline database", e);
        }
        this.setCatalog(catalog);
    }
}

