/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ActionType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.update.ContextInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vcs.update.VcsUpdateTask;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0015\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a \u0010\u001a\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001f\u001a2\u0010 \u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00130!2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\u0013H\u0002\u001a\u001a\u0010'\u001a\u00020(*\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010)0!H\u0002\u001aD\u0010*\u001a\u00020\u0003\"\u0004\b\u0000\u0010+\"\u0004\b\u0001\u0010,*\u0014\u0012\u0004\u0012\u0002H+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H,0.0-2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u0002H+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H,0\u00130!H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "refreshFilesStatus", "", "project", "Lcom/intellij/openapi/project/Project;", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "notifyAnnotations", "notifyFiles", "getFilesCount", "", "group", "Lcom/intellij/openapi/vcs/update/FileGroup;", "prepareUpdatedFilesNotification", "Lcom/intellij/notification/Notification;", "someSessionWasCancelled", "", "additionalContent", "", "", "tree", "Lcom/intellij/openapi/vcs/update/UpdateInfoTree;", "prepareScopeUpdatedText", "Lcom/intellij/openapi/util/text/HtmlChunk;", "Lorg/jetbrains/annotations/Nls;", "getAllFilesAreUpToDateMessage", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "roots", "", "Lcom/intellij/openapi/vcs/FilePath;", "([Lcom/intellij/openapi/vcs/FilePath;)Ljava/lang/String;", "collectExceptions", "", "Lcom/intellij/ide/errorTreeView/HotfixData;", "Lcom/intellij/openapi/vcs/VcsException;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "exceptionList", "fold", "Lcom/intellij/openapi/vcs/update/ContextInfo;", "Lcom/intellij/openapi/vcs/update/SequentialUpdatesContext;", "putAllNonEmpty", "K", "V", "", "", "map", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsUpdateTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsUpdateTask.kt\ncom/intellij/openapi/vcs/update/VcsUpdateTaskKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,396:1\n1#2:397\n1563#3:398\n1634#3,3:399\n13#4:402\n*S KotlinDebug\n*F\n+ 1 VcsUpdateTask.kt\ncom/intellij/openapi/vcs/update/VcsUpdateTaskKt\n*L\n312#1:398\n312#1:399,3\n44#1:402\n*E\n"})
public final class VcsUpdateTaskKt {
    @NotNull
    private static final Logger LOG;

    private static final void refreshFilesStatus(Project project, UpdatedFiles updatedFiles) {
        RemoteRevisionsCache.getInstance(project).invalidate(updatedFiles);
        ArrayList files = new ArrayList();
        UpdateFilesHelper.iterateFileGroupFiles(updatedFiles, (arg_0, arg_1) -> VcsUpdateTaskKt.refreshFilesStatus$lambda$0(files, arg_0, arg_1));
        VcsDirtyScopeManager.getInstance((Project)project).filesDirty((Collection)files, null);
    }

    private static final void notifyAnnotations(Project project, UpdatedFiles updatedFiles) {
        MessageBus messageBus = project.getMessageBus();
        Topic<VcsAnnotationRefresher> topic = VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"LOCAL_CHANGES_CHANGED");
        VcsAnnotationRefresher refresher = (VcsAnnotationRefresher)messageBus.syncPublisher(topic);
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, (arg_0, arg_1) -> VcsUpdateTaskKt.notifyAnnotations$lambda$0(refresher, arg_0, arg_1));
    }

    private static final void notifyFiles(Project project, UpdatedFiles updatedFiles) {
        Set updatedPaths = UpdatedFilesReverseSide.getPathsFromUpdatedFiles((UpdatedFiles)updatedFiles);
        MessageBus messageBus = project.getMessageBus();
        Topic<UpdatedFilesListener> topic = UpdatedFilesListener.UPDATED_FILES;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"UPDATED_FILES");
        ((UpdatedFilesListener)messageBus.syncPublisher(topic)).consume(updatedPaths);
    }

    /*
     * WARNING - void declaration
     */
    private static final int getFilesCount(FileGroup group) {
        int n;
        int n2 = group.getFiles().size();
        List list = group.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable iterable = list;
        int n3 = n2;
        int n4 = 0;
        for (Object t : iterable) {
            void it;
            FileGroup fileGroup = (FileGroup)t;
            n = n4;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            int n5 = VcsUpdateTaskKt.getFilesCount((FileGroup)it);
            n4 = n + n5;
        }
        n = n4;
        return n3 + n;
    }

    /*
     * WARNING - void declaration
     */
    private static final Notification prepareUpdatedFilesNotification(boolean someSessionWasCancelled, UpdatedFiles updatedFiles, List<String> additionalContent, UpdateInfoTree tree) {
        void $this$mapTo$iv$iv;
        HtmlChunk htmlChunk;
        String string;
        Object[] it;
        Object object2;
        Iterable iterable = updatedFiles.getTopLevelGroups();
        int n = 0;
        for (Object object2 : iterable) {
            FileGroup fileGroup = (FileGroup)object2;
            int n2 = n;
            boolean bl = false;
            int n3 = VcsUpdateTaskKt.getFilesCount((FileGroup)it);
            n = n2 + n3;
        }
        int allFilesCount = n;
        if (someSessionWasCancelled) {
            string = VcsBundle.message((String)"update.notification.title.project.partially.updated", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[]{allFilesCount};
            string = VcsBundle.message((String)"update.notification.title.count.files.updated", (Object[])objectArray);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String title = string2;
        HtmlBuilder content = new HtmlBuilder();
        if (someSessionWasCancelled) {
            it = new Object[]{allFilesCount};
            htmlChunk = HtmlChunk.text((String)VcsBundle.message((String)"update.notification.content.files.updated", (Object[])it));
        } else {
            htmlChunk = VcsUpdateTaskKt.prepareScopeUpdatedText(tree);
        }
        object2 = htmlChunk;
        Intrinsics.checkNotNull(object2);
        Object text = object2;
        content.append(text);
        Iterable $this$map$iv = additionalContent;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HtmlChunk.raw((String)it2));
        }
        List additionalContent2 = (List)destination$iv$iv;
        if (!additionalContent2.isEmpty()) {
            if (!content.isEmpty()) {
                content.append((HtmlChunk)HtmlChunk.br());
            }
            content.appendWithSeparators(HtmlChunk.text((String)", "), (Iterable)additionalContent2);
        }
        NotificationType type = someSessionWasCancelled ? NotificationType.WARNING : NotificationType.INFORMATION;
        NotificationGroup notificationGroup = VcsNotifier.standardNotification();
        String string4 = content.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        Notification notification = notificationGroup.createNotification(title, string4, type).setDisplayId("vcs.project.partially.updated");
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
        return notification;
    }

    private static final HtmlChunk prepareScopeUpdatedText(UpdateInfoTree tree) {
        NamedScope namedScope = tree.getFilterScope();
        if (namedScope == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"empty(...)");
            return htmlChunk;
        }
        NamedScope scopeFilter = namedScope;
        int filteredFiles = tree.getFilteredFilesCount();
        String filterName = scopeFilter.getPresentableName();
        if (filteredFiles == 0) {
            Object[] objectArray = new Object[]{filterName};
            HtmlChunk htmlChunk = HtmlChunk.text((String)VcsBundle.message((String)"update.file.name.wasn.t.modified", (Object[])objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(...)");
            return htmlChunk;
        }
        Object[] objectArray = new Object[]{filteredFiles, filterName};
        HtmlChunk htmlChunk = HtmlChunk.text((String)VcsBundle.message((String)"update.filtered.files.count.in.filter.name", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(...)");
        return htmlChunk;
    }

    private static final String getAllFilesAreUpToDateMessage(FilePath[] roots2) {
        if (roots2.length == 1 && !roots2[0].isDirectory()) {
            String string = VcsBundle.message((String)"message.text.file.is.up.to.date", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final Map<HotfixData, List<VcsException>> collectExceptions(AbstractVcs vcs, List<? extends VcsException> exceptionList) {
        VcsExceptionsHotFixer fixer = vcs.getVcsExceptionsHotFixer();
        if (exceptionList.isEmpty()) {
            return MapsKt.emptyMap();
        }
        if (fixer == null) {
            return MapsKt.mapOf((Pair)TuplesKt.to(null, exceptionList));
        }
        Map map = fixer.groupExceptions(ActionType.update, exceptionList);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"groupExceptions(...)");
        return map;
    }

    private static final ContextInfo fold(Map<AbstractVcs, ? extends SequentialUpdatesContext> $this$fold) {
        boolean continueChain2 = false;
        Map exceptions = new LinkedHashMap();
        for (Map.Entry<AbstractVcs, ? extends SequentialUpdatesContext> entry : $this$fold.entrySet()) {
            AbstractVcs vcs = entry.getKey();
            SequentialUpdatesContext context = entry.getValue();
            if (context == null) continue;
            boolean bl = continueChain2 = continueChain2 || context.shouldFail();
            if (!context.shouldFail()) continue;
            VcsException exception = new VcsException(context.getMessageWhenInterruptedBeforeStart());
            Map<HotfixData, List<VcsException>> newExceptions = VcsUpdateTaskKt.collectExceptions(vcs, CollectionsKt.listOf((Object)((Object)exception)));
            VcsUpdateTaskKt.putAllNonEmpty(exceptions, newExceptions);
        }
        return new ContextInfo(continueChain2, exceptions);
    }

    private static final <K, V> void putAllNonEmpty(Map<K, List<V>> $this$putAllNonEmpty, Map<K, ? extends List<? extends V>> map) {
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            K key = entry.getKey();
            List<V> values = entry.getValue();
            if (values.isEmpty()) continue;
            $this$putAllNonEmpty.computeIfAbsent(key, arg_0 -> VcsUpdateTaskKt.putAllNonEmpty$lambda$1(VcsUpdateTaskKt::putAllNonEmpty$lambda$0, arg_0)).addAll((Collection)values);
        }
    }

    private static final void refreshFilesStatus$lambda$0(ArrayList $files, String filePath, String string) {
        Intrinsics.checkNotNull((Object)filePath);
        String string2 = VfsUtilCore.pathToUrl((String)StringsKt.replace$default((String)filePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathToUrl(...)");
        String path = string2;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(path);
        if (file != null) {
            $files.add(file);
        }
    }

    private static final void notifyAnnotations$lambda$0(VcsAnnotationRefresher $refresher, String filePath, String string) {
        $refresher.dirty(filePath);
    }

    private static final List putAllNonEmpty$lambda$0(Object it) {
        return new ArrayList();
    }

    private static final List putAllNonEmpty$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$refreshFilesStatus(Project project, UpdatedFiles updatedFiles) {
        VcsUpdateTaskKt.refreshFilesStatus(project, updatedFiles);
    }

    public static final /* synthetic */ ContextInfo access$fold(Map $receiver) {
        return VcsUpdateTaskKt.fold($receiver);
    }

    public static final /* synthetic */ Map access$collectExceptions(AbstractVcs vcs, List exceptionList) {
        return VcsUpdateTaskKt.collectExceptions(vcs, exceptionList);
    }

    public static final /* synthetic */ void access$putAllNonEmpty(Map $receiver, Map map) {
        VcsUpdateTaskKt.putAllNonEmpty($receiver, map);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$notifyAnnotations(Project project, UpdatedFiles updatedFiles) {
        VcsUpdateTaskKt.notifyAnnotations(project, updatedFiles);
    }

    public static final /* synthetic */ void access$notifyFiles(Project project, UpdatedFiles updatedFiles) {
        VcsUpdateTaskKt.notifyFiles(project, updatedFiles);
    }

    public static final /* synthetic */ Notification access$prepareUpdatedFilesNotification(boolean someSessionWasCancelled, UpdatedFiles updatedFiles, List additionalContent, UpdateInfoTree tree) {
        return VcsUpdateTaskKt.prepareUpdatedFilesNotification(someSessionWasCancelled, updatedFiles, additionalContent, tree);
    }

    public static final /* synthetic */ String access$getAllFilesAreUpToDateMessage(FilePath[] roots2) {
        return VcsUpdateTaskKt.getAllFilesAreUpToDateMessage(roots2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsUpdateTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

