/*
 * Decompiled with CFR 0.152.
 */
package com.github.jgonian.ipmath;

import com.github.jgonian.ipmath.AbstractIp;
import com.github.jgonian.ipmath.AbstractIpRange;
import com.github.jgonian.ipmath.Ipv6;
import com.github.jgonian.ipmath.Optional;
import com.github.jgonian.ipmath.SizeComparator;
import com.github.jgonian.ipmath.SortedRangeSet;
import com.github.jgonian.ipmath.StartAndSizeComparator;
import com.github.jgonian.ipmath.Validate;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class PrefixUtils {
    private PrefixUtils() {
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> boolean isLegalPrefix(AbstractIpRange<C, R> range) {
        int prefixLength = ((AbstractIp)range.start()).getCommonPrefixLength((AbstractIp)range.end());
        Object lowerBoundForPrefix = ((AbstractIp)range.start()).lowerBoundForPrefix(prefixLength);
        Object upperBoundForPrefix = ((AbstractIp)range.end()).upperBoundForPrefix(prefixLength);
        return ((AbstractIp)range.start()).equals(lowerBoundForPrefix) && ((AbstractIp)range.end()).equals(upperBoundForPrefix);
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> int getPrefixLength(AbstractIpRange<C, R> range) {
        Validate.isTrue(PrefixUtils.isLegalPrefix(range), range.toStringInRangeNotation() + " is not a legal prefix, cannot get prefix length!");
        return ((AbstractIp)range.start()).getCommonPrefixLength((AbstractIp)range.end());
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> Optional<R> findMinimumPrefixForPrefixLength(R range, int prefixLength) {
        Validate.checkRange(prefixLength, 0, ((AbstractIp)range.start()).bitSize());
        return PrefixUtils.findPrefixForPrefixLength(range, prefixLength, SizeComparator.get());
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> Optional<R> findMaximumPrefixForPrefixLength(R range, int prefixLength) {
        Validate.checkRange(prefixLength, 0, ((AbstractIp)range.start()).bitSize());
        return PrefixUtils.findPrefixForPrefixLength(range, prefixLength, SizeComparator.reverse());
    }

    private static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> Optional<R> findPrefixForPrefixLength(R range, int prefixLength, Comparator<? super R> comparator) {
        List<R> prefixes = range.splitToPrefixes();
        Collections.sort(prefixes, comparator);
        for (AbstractIpRange prefix : prefixes) {
            if (prefixLength < PrefixUtils.getPrefixLength(prefix)) continue;
            return Optional.of(prefix);
        }
        return Optional.absent();
    }

    public static int findMaxPrefixLengthForAddress(Ipv6 address) {
        return PrefixUtils.getMaxValidPrefix(address.value());
    }

    private static int getMaxValidPrefix(BigInteger number) {
        int powerOfTwo;
        int maxPowerOfTwo = powerOfTwo = 0;
        while (powerOfTwo <= 128 && number.divideAndRemainder(BigInteger.ONE.shiftLeft(powerOfTwo))[1].compareTo(BigInteger.ZERO) == 0) {
            maxPowerOfTwo = powerOfTwo++;
        }
        return 128 - maxPowerOfTwo;
    }

    public static int sumIpv4Prefixes(List<Integer> ipv4Prefixes) {
        return PrefixUtils.doSumIpvX(ipv4Prefixes, 32);
    }

    public static int sumIpv6Prefixes(List<Integer> ipv6Prefixes) {
        return PrefixUtils.doSumIpvX(ipv6Prefixes, 128);
    }

    private static int doSumIpvX(List<Integer> prefixes, int bitSize) {
        double addressSize = 0.0;
        for (Integer prefix : prefixes) {
            Validate.checkRange(prefix, 1, bitSize);
            addressSize += Math.pow(2.0, bitSize - prefix);
        }
        return (int)Math.floor((double)bitSize - Math.log(addressSize) / Math.log(2.0));
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> SortedSet<R> excludeFromRangeAndSplitIntoPrefixes(R originalRange, Set<R> rangesToExclude) {
        SortedRangeSet remainingRanges = new SortedRangeSet();
        remainingRanges.add(originalRange);
        remainingRanges.removeAll(rangesToExclude);
        TreeSet prefixes = new TreeSet(StartAndSizeComparator.get());
        for (AbstractIpRange assignmentRange : remainingRanges) {
            for (AbstractIpRange range : assignmentRange.splitToPrefixes()) {
                prefixes.add(range);
            }
        }
        return prefixes;
    }
}

