/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import oracle.security.pki.TransitionMode;

public final class JCEUtil {
    public static final String JSAFEJCE_CLASS_NAME = "com.rsa.jsafe.provider.JsafeJCE";
    public static final String CRYPTOJ_CLASS_NAME = "com.rsa.jsafe.crypto.CryptoJ";
    public static final String FIPS140CONTEXT_CLASS_NAME = "com.rsa.jsafe.crypto.FIPS140Context";
    public static final String FIPS140_MODE_FIELD_NAME = "FIPS140_MODE";
    public static final String JSAFEJCE_NAME = "JsafeJCE";
    public static final String SECURE_RANDOM_ALG = "CTRDRBG";
    public static final String JSAFEJCE_SECURE_RANDOM_ALG = "DefaultRandom";
    public static final String JCE_FIPS140_PROVIDER_CLASS_SECURITY_PROPERTY = "oracle.security.crypto.jce.fips140_provider_class";
    private static final String a;
    private static final boolean b;
    private static boolean c;
    private static boolean d;
    private static Provider e;
    private static SecureRandom f;

    public static synchronized boolean isJsafeJCERegistered() {
        if (b && TransitionMode.isFIPS140ModeEnabled()) {
            return true;
        }
        if (!d) {
            if (Security.getProvider(JSAFEJCE_NAME) != null) {
                c = true;
            } else {
                Provider[] providerArray = Security.getProviders();
                c = false;
                for (Provider provider : providerArray) {
                    String string = provider.getName();
                    if (!string.startsWith("JsafeJCE/")) continue;
                    c = true;
                    break;
                }
            }
            d = true;
        }
        return c;
    }

    private static Provider b() throws NoSuchAlgorithmException {
        try {
            return JCEUtil.getJCEProvider();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(noSuchProviderException.getMessage(), noSuchProviderException);
        }
    }

    private static Provider c() throws CertificateException {
        try {
            return JCEUtil.getJCEProvider();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CertificateException(noSuchProviderException.getMessage(), noSuchProviderException);
        }
    }

    public static synchronized Provider getJCEProvider() throws NoSuchProviderException {
        if (e == null) {
            e = JCEUtil.a(a, TransitionMode.isFIPS140ModeEnabled() && b);
            if (TransitionMode.isFIPS140ModeEnabled()) {
                JCEUtil.a(e);
            }
        }
        return e;
    }

    private static Provider a(final String string, final boolean bl) throws NoSuchProviderException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Provider>(){

                public Provider a() throws ReflectiveOperationException, NoSuchProviderException {
                    if (bl) {
                        Object obj;
                        Class<?> clazz = Class.forName(JCEUtil.CRYPTOJ_CLASS_NAME);
                        Field field = clazz.getField(JCEUtil.FIPS140_MODE_FIELD_NAME);
                        int n = field.getInt(null);
                        Class<?> clazz2 = Class.forName(JCEUtil.FIPS140CONTEXT_CLASS_NAME);
                        Constructor<?> constructor = clazz2.getConstructor(Integer.TYPE);
                        try {
                            obj = constructor.newInstance(n);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            NoSuchProviderException noSuchProviderException = new NoSuchProviderException("The available JsafeJCE provider is not the FIPS 140 variant: " + string);
                            noSuchProviderException.initCause(invocationTargetException.getCause());
                            throw noSuchProviderException;
                        }
                        Class<?> clazz3 = Class.forName(string);
                        Constructor<?> constructor2 = clazz3.getConstructor(clazz2);
                        return (Provider)constructor2.newInstance(obj);
                    }
                    return (Provider)Class.forName(string).newInstance();
                }

                @Override
                public /* synthetic */ Object run() throws Exception {
                    return this.a();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)throwable;
            }
            NoSuchProviderException noSuchProviderException = new NoSuchProviderException("Unable to instantiate the configured JCE provider: " + string);
            noSuchProviderException.initCause(throwable);
            throw noSuchProviderException;
        }
    }

    static synchronized void a() {
        e = null;
        f = null;
    }

    private static void a(final Provider provider) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            public Void a() {
                Security.removeProvider(provider.getName());
                Security.insertProviderAt(provider, 1);
                return null;
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        });
    }

    public static synchronized void registerJsafeJCE() throws NoSuchProviderException {
        if (b) {
            Provider provider = JCEUtil.getJCEProvider();
            JCEUtil.a(provider);
        } else if (!JCEUtil.isJsafeJCERegistered()) {
            Provider provider = JCEUtil.a(JSAFEJCE_CLASS_NAME, false);
            JCEUtil.a(provider);
        }
    }

    public static synchronized SecureRandom getSecureRandom() {
        if (f == null) {
            if (TransitionMode.isFIPS140ModeEnabled()) {
                String string = b ? JSAFEJCE_SECURE_RANDOM_ALG : SECURE_RANDOM_ALG;
                try {
                    f = SecureRandom.getInstance(string, JCEUtil.getJCEProvider());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    InternalError internalError = new InternalError("SecureRandom algorithm " + string + " not available");
                    internalError.initCause(generalSecurityException);
                    throw internalError;
                }
            } else {
                f = new SecureRandom();
            }
        }
        return f;
    }

    public static final Signature getSignatureInstance(String string) throws NoSuchAlgorithmException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return Signature.getInstance(string, JCEUtil.b());
        }
        return Signature.getInstance(string);
    }

    public static final Mac getMacInstance(String string) throws NoSuchAlgorithmException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return Mac.getInstance(string, JCEUtil.b());
        }
        return Mac.getInstance(string);
    }

    public static final MessageDigest getMessageDigestInstance(String string) throws NoSuchAlgorithmException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return MessageDigest.getInstance(string, JCEUtil.b());
        }
        return MessageDigest.getInstance(string);
    }

    public static final SecretKeyFactory getSecretKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return SecretKeyFactory.getInstance(string, JCEUtil.b());
        }
        return SecretKeyFactory.getInstance(string);
    }

    public static final Cipher getCipherInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return Cipher.getInstance(string, JCEUtil.b());
        }
        return Cipher.getInstance(string);
    }

    public static final KeyPairGenerator getKeyPairGeneratorInstance(String string) throws NoSuchAlgorithmException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return KeyPairGenerator.getInstance(string, JCEUtil.b());
        }
        return KeyPairGenerator.getInstance(string);
    }

    public static final KeyFactory getKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return KeyFactory.getInstance(string, JCEUtil.b());
        }
        return KeyFactory.getInstance(string);
    }

    public static final KeyAgreement getKeyAgreementInstance(String string) throws NoSuchAlgorithmException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return KeyAgreement.getInstance(string, JCEUtil.b());
        }
        return KeyAgreement.getInstance(string);
    }

    public static final CertificateFactory getCertificateFactoryInstance(String string) throws CertificateException {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return CertificateFactory.getInstance(string, JCEUtil.c());
        }
        return CertificateFactory.getInstance(string);
    }

    static {
        d = false;
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            public String a() {
                return Security.getProperty(JCEUtil.JCE_FIPS140_PROVIDER_CLASS_SECURITY_PROPERTY);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        });
        if (string == null) {
            string = JSAFEJCE_CLASS_NAME;
            b = true;
        } else {
            b = string.equalsIgnoreCase(JSAFEJCE_CLASS_NAME);
        }
        a = string;
    }
}

