/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.resources.RealmsResource;

@Provider
@Path(value="/.well-known")
public class ServerMetadataResource {
    protected static final Logger logger = Logger.getLogger(ServerMetadataResource.class);
    @Context
    protected KeycloakSession session;

    @OPTIONS
    @Path(value="{provider}/realms/{realm}")
    @Produces(value={"application/json"})
    public Response getOAuth2AuthorizationServerWellKnownVersionPreflight(@PathParam(value="provider") String providerName, @PathParam(value="realm") String name) {
        if (!this.isValidProvider(providerName)) {
            throw new NotFoundException();
        }
        return Cors.builder().allowedMethods(new String[]{"GET"}).preflight().auth().add(Response.ok());
    }

    @GET
    @Path(value="{provider}/realms/{realm}")
    @Produces(value={"application/json", "application/jwt"})
    public Response getOAuth2AuthorizationServerWellKnown(@PathParam(value="provider") String providerName, @PathParam(value="realm") String name) {
        if (!this.isValidProvider(providerName)) {
            throw new NotFoundException();
        }
        return RealmsResource.getWellKnownResponse(this.session, name, providerName, logger);
    }

    public static UriBuilder wellKnownOAuthProviderUrl(UriBuilder builder) {
        return builder.path(ServerMetadataResource.class).path("{provider}/realms/{realm}");
    }

    private boolean isValidProvider(String providerName) {
        if ("oauth-authorization-server".equals(providerName)) {
            return true;
        }
        if ("openid-credential-issuer".equals(providerName)) {
            return true;
        }
        return "jwt-vc-issuer".equals(providerName);
    }
}

