/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.uri;

import com.apicatalog.jsonld.uri.Path;
import com.apicatalog.jsonld.uri.UriUtils;
import java.net.URI;
import java.util.Objects;

public final class UriRelativizer {
    private UriRelativizer() {
    }

    public static final String relativize(URI base, String uri) {
        if (base == null) {
            return uri;
        }
        return UriRelativizer.relativize(base, URI.create(uri));
    }

    public static final String relativize(URI base, URI uri) {
        Path basePath;
        if (base == null || !base.isAbsolute() || !uri.isAbsolute()) {
            return uri.toString();
        }
        if (!Objects.equals(base.getScheme(), uri.getScheme())) {
            return uri.toString();
        }
        if (!Objects.equals(base.getAuthority(), uri.getAuthority())) {
            return uri.toString();
        }
        Path uriPath = Path.of(uri.getPath());
        Path path = uriPath.relativize(basePath = Path.of(base.getPath()));
        if (path.isNotEmpty()) {
            return UriUtils.recompose(null, null, path.toString(), uri.getQuery(), uri.getFragment());
        }
        if (!Objects.equals(base.getQuery(), uri.getQuery())) {
            return UriUtils.recompose(null, null, null, uri.getQuery(), uri.getFragment());
        }
        if (!Objects.equals(base.getFragment(), uri.getFragment())) {
            return UriUtils.recompose(null, null, null, null, uri.getFragment());
        }
        return uriPath.getLeaf() != null ? uriPath.getLeaf() : "./";
    }
}

