/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class LevelFilter
implements Filter {
    private final Set<Level> includedLevels;

    public LevelFilter(Level includedLevel) {
        this.includedLevels = Collections.singleton(includedLevel);
    }

    public LevelFilter(Collection<Level> includedLevels) {
        this.includedLevels = new HashSet<Level>(includedLevels);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.includedLevels.contains(record.getLevel());
    }
}

