/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.FormatStep;

public class MultistepFormatter
extends ExtFormatter {
    private volatile FormatStep[] steps;
    private volatile int builderLength;
    private volatile boolean callerCalculationRequired = false;
    private static final FormatStep[] EMPTY_STEPS = new FormatStep[0];

    public MultistepFormatter(FormatStep[] steps) {
        this.steps = (FormatStep[])steps.clone();
        this.calculateBuilderLength();
    }

    private void calculateBuilderLength() {
        boolean callerCalculatedRequired = false;
        int builderLength = 0;
        for (FormatStep step : this.steps) {
            builderLength += step.estimateLength();
            if (!step.isCallerInformationRequired()) continue;
            callerCalculatedRequired = true;
        }
        this.builderLength = Math.max(32, builderLength);
        this.callerCalculationRequired = callerCalculatedRequired;
    }

    public MultistepFormatter() {
        this.steps = EMPTY_STEPS;
    }

    public FormatStep[] getSteps() {
        return (FormatStep[])this.steps.clone();
    }

    public void setSteps(FormatStep[] steps) {
        this.steps = steps == null || steps.length == 0 ? EMPTY_STEPS : (FormatStep[])steps.clone();
        this.calculateBuilderLength();
    }

    @Override
    public String format(ExtLogRecord record) {
        StringBuilder builder = new StringBuilder(this.builderLength);
        for (FormatStep step : this.steps) {
            step.render(this, builder, record);
        }
        return builder.toString();
    }

    @Override
    public boolean isCallerCalculationRequired() {
        return this.callerCalculationRequired;
    }
}

