# frozen_string_literal: true

module Labkit
  module CoveredExperience
    # Fakes Labkit::CoveredExperience::Experience.
    class Null
      include Singleton

      def id = 'null'

      def start(**_extra)
        yield self if block_given?
        self
      end

      def resume(**_extra)
        yield self if block_given?
        self
      end

      def push_attributes!(*_args) = self
      def checkpoint(*_args) = self
      def complete(*_args) = self
      def error!(*_args) = self
      def rehydrate(*_args, **_kwargs) = self
      def to_h = {}
    end
  end
end
