## Contributor License Agreement and Developer Certificate of Origin

Contributions to this repository are subject to the [Developer Certificate of Origin](doc/legal/developer_certificate_of_origin.md#developer-certificate-of-origin-version-11), or the [Individual](doc/legal/individual_contributor_license_agreement.md) or [Corporate](doc/legal/corporate_contributor_license_agreement.md) Contributor License Agreement, depending on where the contribution is made and on whose behalf unless otherwise agreed with GitLab in writing:

- By submitting code contributions as an individual to the [`/ee` subdirectory](/ee) of this repository, you agree to the [Individual Contributor License Agreement](doc/legal/individual_contributor_license_agreement.md).

- By submitting code contributions on behalf of a corporation to the [`/ee` subdirectory](/ee) of this repository, you agree to the [Corporate Contributor License Agreement](doc/legal/corporate_contributor_license_agreement.md).

- By submitting code contributions as an individual or on behalf of a corporation to any directory in this repository outside of the [`/ee` subdirectory](/ee), you agree to the [Developer Certificate of Origin](doc/legal/developer_certificate_of_origin.md#developer-certificate-of-origin-version-11).

All Documentation content that resides under the [`doc/` directory](/doc) of this
repository is licensed under Creative Commons:
[CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).

_This notice should stay as the first item in the `CONTRIBUTING.md` file._

## Contribute to GitLab

[View the documentation](https://about.gitlab.com/community/contribute/) to find the latest information.

## Security vulnerability disclosure

[View the documentation](https://about.gitlab.com/security/disclosure/) to find the latest information.

## Code of Conduct

[View the documentation](https://about.gitlab.com/community/contribute/code-of-conduct/) to find the latest information.

## Closing policy for issues and merge requests

[View the documentation](doc/development/contributing/index.md#closing-policy-for-issues-and-merge-requests) to find the latest information.

## Helping others

[View the documentation](doc/development/contributing/index.md#helping-others) to find the latest information.

## I want to contribute!

[View the documentation](https://about.gitlab.com/community/contribute/) to find the latest information.

## Contribution Flow

[View the documentation](doc/development/contributing/index.md) to find the latest information.

## Workflow labels

View the [issue workflow](doc/development/contributing/issue_workflow.md) documentation for these subjects:

- Type labels
- Subject labels
- Team labels
- Release Scoping labels
- Priority labels
- Severity labels
  - Severity impact guidance
- Labels for community contributors

## Implement design & UI elements

[View the documentation](doc/development/contributing/design.md) to find the latest information.

## Issue tracker

View the [issue workflow](doc/development/contributing/issue_workflow.md) documentation for the following subjects.

- Issue triaging
- Feature proposals
- Issue tracker guidelines
- Issue weight
- Regression issues
- Technical and UX debt
- Stewardship

## Merge requests

View the [merge request workflow](doc/development/contributing/merge_request_workflow.md) documentation for the following subjects.

- Merge request guidelines
- Contribution acceptance criteria

## Community forks

We recommend using the [community fork](https://gitlab.com/gitlab-community/gitlab-org/gitlab) to create merge requests.

The [@gitlab-community README.md](https://gitlab.com/gitlab-community#gitlab-community-forks) provides more detail of what, why, and how to use the community fork. 

## Definition of done

[View the documentation](doc/development/contributing/merge_request_workflow.md) to find the latest information.

## Style guides

[View the documentation](doc/development/contributing/style_guides.md) to find the latest information.
