/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.TextNode;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.parser.UnitProcessor;
import io.sf.carte.echosvg.util.CSSConstants;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TextUtilities
implements CSSConstants,
ErrorConstants {
    public static String getElementContent(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    stringBuilder.append(TextUtilities.getElementContent((Element)node));
                    continue block4;
                }
                case 3: 
                case 4: {
                    stringBuilder.append(node.getNodeValue());
                }
            }
        }
        return stringBuilder.toString();
    }

    public static ArrayList<Float> svgHorizontalCoordinateArrayToUserSpace(Element element, String string, String string2, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(Float.valueOf(UnitProcessor.svgHorizontalCoordinateToUserSpace(stringTokenizer.nextToken(), string, context)));
        }
        return arrayList;
    }

    public static ArrayList<Float> svgVerticalCoordinateArrayToUserSpace(Element element, String string, String string2, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(Float.valueOf(UnitProcessor.svgVerticalCoordinateToUserSpace(stringTokenizer.nextToken(), string, context)));
        }
        return arrayList;
    }

    public static ArrayList<Float> svgRotateArrayToFloats(Element element, String string, String string2, BridgeContext bridgeContext) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string3 = stringTokenizer.nextToken();
                arrayList.add(Float.valueOf((float)Math.toRadians(SVGUtilities.convertSVGNumber(string3))));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{string, string2});
            }
        }
        return arrayList;
    }

    public static Float convertFontSize(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 21);
        return Float.valueOf(value.getFloatValue());
    }

    public static Float convertFontStyle(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 24);
        switch (value.getIdentifierValue().charAt(0)) {
            case 'n': {
                return TextAttribute.POSTURE_REGULAR;
            }
        }
        return TextAttribute.POSTURE_OBLIQUE;
    }

    public static Float convertFontStretch(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 23);
        String string = value.getIdentifierValue();
        switch (string.charAt(0)) {
            case 'u': {
                if (string.charAt(6) == 'c') {
                    return TextAttribute.WIDTH_CONDENSED;
                }
                return TextAttribute.WIDTH_EXTENDED;
            }
            case 'e': {
                if (string.charAt(6) == 'c') {
                    return TextAttribute.WIDTH_CONDENSED;
                }
                if (string.length() == 8) {
                    return TextAttribute.WIDTH_SEMI_EXTENDED;
                }
                return TextAttribute.WIDTH_EXTENDED;
            }
            case 's': {
                if (string.charAt(6) == 'c') {
                    return TextAttribute.WIDTH_SEMI_CONDENSED;
                }
                return TextAttribute.WIDTH_SEMI_EXTENDED;
            }
        }
        return TextAttribute.WIDTH_REGULAR;
    }

    public static Float convertFontWeight(Element element) {
        float f;
        Value value = CSSUtilities.getComputedStyle(element, 26);
        int n = (int)value.getFloatValue();
        switch (n) {
            case 100: {
                return TextAttribute.WEIGHT_EXTRA_LIGHT;
            }
            case 200: {
                return TextAttribute.WEIGHT_LIGHT;
            }
            case 300: {
                return TextAttribute.WEIGHT_DEMILIGHT;
            }
            case 400: {
                return TextAttribute.WEIGHT_REGULAR;
            }
            case 500: {
                return TextAttribute.WEIGHT_SEMIBOLD;
            }
        }
        String string = System.getProperty("java.specification.version");
        float f2 = f = string != null ? Float.parseFloat(string) : 1.5f;
        if ((double)f < 1.5) {
            return TextAttribute.WEIGHT_BOLD;
        }
        switch (n) {
            case 600: {
                return TextAttribute.WEIGHT_MEDIUM;
            }
            case 700: {
                return TextAttribute.WEIGHT_BOLD;
            }
            case 800: {
                return TextAttribute.WEIGHT_HEAVY;
            }
            case 900: {
                return TextAttribute.WEIGHT_ULTRABOLD;
            }
        }
        return TextAttribute.WEIGHT_REGULAR;
    }

    public static TextNode.Anchor convertTextAnchor(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 57);
        switch (value.getIdentifierValue().charAt(0)) {
            case 's': {
                return TextNode.Anchor.START;
            }
            case 'm': {
                return TextNode.Anchor.MIDDLE;
            }
        }
        return TextNode.Anchor.END;
    }

    public static Object convertBaselineShift(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 1);
        if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
            String string = value.getIdentifierValue();
            switch (string.charAt(2)) {
                case 'p': {
                    return TextAttribute.SUPERSCRIPT_SUPER;
                }
                case 'b': {
                    return TextAttribute.SUPERSCRIPT_SUB;
                }
            }
            return null;
        }
        return Float.valueOf(value.getFloatValue());
    }

    public static Float convertKerning(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 30);
        if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
            return null;
        }
        return Float.valueOf(value.getFloatValue());
    }

    public static Float convertLetterSpacing(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 31);
        if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
            return null;
        }
        return Float.valueOf(value.getFloatValue());
    }

    public static Float convertWordSpacing(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 62);
        if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
            return null;
        }
        return Float.valueOf(value.getFloatValue());
    }
}

