/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt;

import org.freeplane.features.encrypt.Aes256Encrypter;
import org.freeplane.features.encrypt.SingleDesEncrypter;
import org.freeplane.features.map.IEncrypter;

public class EncryptionHelper {
    public static IEncrypter createEncrypter(StringBuilder password) {
        return new Aes256Encrypter(password);
    }

    public static IEncrypter createDecrypter(StringBuilder password, String encryptedContent) {
        if (encryptedContent == null) {
            return new Aes256Encrypter(password);
        }
        if (encryptedContent.startsWith("FP-AES256-V1:")) {
            return new Aes256Encrypter(password);
        }
        return new SingleDesEncrypter(password);
    }

    public static String getEncryptionAlgorithmDescription(String encryptedContent) {
        if (encryptedContent == null) {
            return "Unknown";
        }
        if (encryptedContent.startsWith("FP-AES256-V1:")) {
            return "AES-256";
        }
        return "DES";
    }
}

