/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.util.Arrays;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TopValue;
import proguard.evaluation.value.Value;

public class Variables {
    private static final TopValue TOP_VALUE = new TopValue();
    protected Value[] values;
    protected int size;

    public Variables(int size) {
        this.values = new Value[size];
        this.size = size;
    }

    public Variables(Variables variables) {
        this(variables.size);
        this.initialize(variables);
    }

    public void reset(int size) {
        if (this.values.length < size) {
            this.values = new Value[size];
        } else {
            Arrays.fill(this.values, 0, this.size, null);
        }
        this.size = size;
    }

    public void initialize(Variables other) {
        if (this.size < other.size) {
            throw new IllegalArgumentException("Variable frame is too small [" + this.size + "] compared to other frame [" + other.size + "]");
        }
        System.arraycopy(other.values, 0, this.values, 0, other.size);
    }

    public boolean generalize(Variables other, boolean clearConflictingOtherVariables) {
        if (this.size != other.size) {
            throw new IllegalArgumentException("Variable frames have different sizes [" + this.size + "] and [" + other.size + "]");
        }
        boolean changed = false;
        for (int index = 0; index < this.size; ++index) {
            Value thisValue = this.values[index];
            Value otherValue = other.values[index];
            if (thisValue != null && otherValue != null && thisValue.computationalType() == otherValue.computationalType()) {
                Value newValue = thisValue.generalize(otherValue);
                changed = changed || !thisValue.equals(newValue);
                this.values[index] = newValue;
                continue;
            }
            changed = changed || thisValue != null;
            this.values[index] = null;
            if (!clearConflictingOtherVariables) continue;
            other.values[index] = null;
        }
        return changed;
    }

    public int size() {
        return this.size;
    }

    public Value getValue(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Variable index [" + index + "] out of bounds [" + this.size + "]");
        }
        return this.values[index];
    }

    public void store(int index, Value value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Variable index [" + index + "] out of bounds [" + this.size + "]");
        }
        this.values[index] = value;
        if (value.isCategory2()) {
            this.values[index + 1] = TOP_VALUE;
        }
    }

    public Value load(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Variable index [" + index + "] out of bounds [" + this.size + "]");
        }
        return this.values[index];
    }

    public IntegerValue iload(int index) {
        return this.load(index).integerValue();
    }

    public LongValue lload(int index) {
        return this.load(index).longValue();
    }

    public FloatValue fload(int index) {
        return this.load(index).floatValue();
    }

    public DoubleValue dload(int index) {
        return this.load(index).doubleValue();
    }

    public ReferenceValue aload(int index) {
        return this.load(index).referenceValue();
    }

    public InstructionOffsetValue oload(int index) {
        return this.load(index).instructionOffsetValue();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Variables other = (Variables)object;
        if (this.size != other.size) {
            return false;
        }
        for (int index = 0; index < this.size; ++index) {
            Value thisValue = this.values[index];
            Value otherValue = other.values[index];
            if (thisValue == null || otherValue == null || thisValue.computationalType() != otherValue.computationalType() || thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.size;
        for (int index = 0; index < this.size; ++index) {
            Value value = this.values[index];
            if (value == null) continue;
            hashCode ^= value.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < this.size; ++index) {
            Value value = this.values[index];
            buffer = buffer.append('[').append(value == null ? "empty" : value.toString()).append(']');
        }
        return buffer.toString();
    }
}

