﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kendra/KendraRequest.h>
#include <aws/kendra/Kendra_EXPORTS.h>

#include <utility>

namespace Aws {
namespace kendra {
namespace Model {

/**
 */
class ListGroupsOlderThanOrderingIdRequest : public KendraRequest {
 public:
  AWS_KENDRA_API ListGroupsOlderThanOrderingIdRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListGroupsOlderThanOrderingId"; }

  AWS_KENDRA_API Aws::String SerializePayload() const override;

  AWS_KENDRA_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the index for getting a list of groups mapped to users
   * before a given ordering or timestamp identifier.</p>
   */
  inline const Aws::String& GetIndexId() const { return m_indexId; }
  inline bool IndexIdHasBeenSet() const { return m_indexIdHasBeenSet; }
  template <typename IndexIdT = Aws::String>
  void SetIndexId(IndexIdT&& value) {
    m_indexIdHasBeenSet = true;
    m_indexId = std::forward<IndexIdT>(value);
  }
  template <typename IndexIdT = Aws::String>
  ListGroupsOlderThanOrderingIdRequest& WithIndexId(IndexIdT&& value) {
    SetIndexId(std::forward<IndexIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the data source for getting a list of groups mapped to
   * users before a given ordering timestamp identifier.</p>
   */
  inline const Aws::String& GetDataSourceId() const { return m_dataSourceId; }
  inline bool DataSourceIdHasBeenSet() const { return m_dataSourceIdHasBeenSet; }
  template <typename DataSourceIdT = Aws::String>
  void SetDataSourceId(DataSourceIdT&& value) {
    m_dataSourceIdHasBeenSet = true;
    m_dataSourceId = std::forward<DataSourceIdT>(value);
  }
  template <typename DataSourceIdT = Aws::String>
  ListGroupsOlderThanOrderingIdRequest& WithDataSourceId(DataSourceIdT&& value) {
    SetDataSourceId(std::forward<DataSourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp identifier used for the latest <code>PUT</code> or
   * <code>DELETE</code> action for mapping users to their groups.</p>
   */
  inline long long GetOrderingId() const { return m_orderingId; }
  inline bool OrderingIdHasBeenSet() const { return m_orderingIdHasBeenSet; }
  inline void SetOrderingId(long long value) {
    m_orderingIdHasBeenSet = true;
    m_orderingId = value;
  }
  inline ListGroupsOlderThanOrderingIdRequest& WithOrderingId(long long value) {
    SetOrderingId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> If the previous response was incomplete (because there is more data to
   * retrieve), Amazon Kendra returns a pagination token in the response. You can use
   * this pagination token to retrieve the next set of groups that are mapped to
   * users before a given ordering or timestamp identifier. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListGroupsOlderThanOrderingIdRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The maximum number of returned groups that are mapped to users before a
   * given ordering or timestamp identifier. </p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListGroupsOlderThanOrderingIdRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_indexId;

  Aws::String m_dataSourceId;

  long long m_orderingId{0};

  Aws::String m_nextToken;

  int m_maxResults{0};
  bool m_indexIdHasBeenSet = false;
  bool m_dataSourceIdHasBeenSet = false;
  bool m_orderingIdHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace kendra
}  // namespace Aws
