﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoT {
namespace Model {

/**
 */
class DescribeManagedJobTemplateRequest : public IoTRequest {
 public:
  AWS_IOT_API DescribeManagedJobTemplateRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeManagedJobTemplate"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  AWS_IOT_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The unique name of a managed job template, which is required.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  DescribeManagedJobTemplateRequest& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An optional parameter to specify version of a managed template. If not
   * specified, the pre-defined default version is returned.</p>
   */
  inline const Aws::String& GetTemplateVersion() const { return m_templateVersion; }
  inline bool TemplateVersionHasBeenSet() const { return m_templateVersionHasBeenSet; }
  template <typename TemplateVersionT = Aws::String>
  void SetTemplateVersion(TemplateVersionT&& value) {
    m_templateVersionHasBeenSet = true;
    m_templateVersion = std::forward<TemplateVersionT>(value);
  }
  template <typename TemplateVersionT = Aws::String>
  DescribeManagedJobTemplateRequest& WithTemplateVersion(TemplateVersionT&& value) {
    SetTemplateVersion(std::forward<TemplateVersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_templateName;
  bool m_templateNameHasBeenSet = false;

  Aws::String m_templateVersion;
  bool m_templateVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
