/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.deciders;

import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;

public class IntraSegmentSearchDecider {
    private boolean querySupport = true;
    private boolean aggSupport = true;
    private String reason = "no query or aggregation evaluated";
    private boolean hasQuery = false;
    private boolean hasAggregations = false;

    public void evaluateForQuery(QueryBuilder queryBuilder) {
        this.hasQuery = true;
        if (!queryBuilder.supportsIntraSegmentSearch()) {
            this.querySupport = false;
            this.reason = queryBuilder.getName() + " does not support intra-segment search";
        }
    }

    public void evaluateForAggregations(AggregatorFactories aggregations) {
        if (aggregations == null) {
            return;
        }
        this.hasAggregations = true;
        if (!aggregations.allFactoriesSupportIntraSegmentSearch()) {
            this.aggSupport = false;
            this.reason = "some aggregations do not support intra-segment search";
        }
    }

    public boolean shouldUseIntraSegmentSearch() {
        if (this.hasQuery && !this.querySupport) {
            return false;
        }
        if (this.hasAggregations && !this.aggSupport) {
            return false;
        }
        return this.hasQuery || this.hasAggregations;
    }

    public String getReason() {
        if (this.shouldUseIntraSegmentSearch()) {
            return "query/aggregations support intra-segment search";
        }
        return this.reason;
    }
}

