/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.Interval;
import org.jetbrains.kotlin.codegen.inline.SimpleInterval;
import org.jetbrains.kotlin.codegen.inline.SplitPair;
import org.jetbrains.kotlin.codegen.inline.SplittableInterval;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0001H\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/LocalVarNodeWrapper;", "Lorg/jetbrains/kotlin/codegen/inline/Interval;", "Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;", "node", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;)V", "getNode", "()Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "startLabel", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getStartLabel", "()Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "endLabel", "getEndLabel", "split", "Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "splitBy", "keepStart", "", "copyWithNewBounds", "newBounds", "remapLabel", "", "oldLabel", "newLabel", "backend"})
public final class LocalVarNodeWrapper
implements Interval,
SplittableInterval<LocalVarNodeWrapper> {
    @NotNull
    private final LocalVariableNode node;

    public LocalVarNodeWrapper(@NotNull LocalVariableNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
    }

    @NotNull
    public final LocalVariableNode getNode() {
        return this.node;
    }

    @Override
    @NotNull
    public LabelNode getStartLabel() {
        LabelNode labelNode = this.node.start;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
        return labelNode;
    }

    @Override
    @NotNull
    public LabelNode getEndLabel() {
        LabelNode labelNode = this.node.end;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"end");
        return labelNode;
    }

    @Override
    @NotNull
    public SplitPair<LocalVarNodeWrapper> split(@NotNull Interval splitBy, boolean keepStart) {
        SimpleInterval simpleInterval;
        Intrinsics.checkNotNullParameter((Object)splitBy, (String)"splitBy");
        if (keepStart) {
            LabelNode oldEnd = this.getEndLabel();
            this.node.end = splitBy.getStartLabel();
            simpleInterval = new SimpleInterval(splitBy.getEndLabel(), oldEnd);
        } else {
            LabelNode oldStart = this.getStartLabel();
            this.node.start = splitBy.getEndLabel();
            simpleInterval = new SimpleInterval(oldStart, splitBy.getStartLabel());
        }
        SimpleInterval newPartInterval = simpleInterval;
        return new SplitPair<Interval>(this, this.copyWithNewBounds(newPartInterval));
    }

    @Override
    @NotNull
    public LocalVarNodeWrapper copyWithNewBounds(@NotNull Interval newBounds) {
        Intrinsics.checkNotNullParameter((Object)newBounds, (String)"newBounds");
        return new LocalVarNodeWrapper(new LocalVariableNode(this.node.name, this.node.desc, this.node.signature, newBounds.getStartLabel(), newBounds.getEndLabel(), this.node.index));
    }

    public final void remapLabel(@NotNull LabelNode oldLabel, @NotNull LabelNode newLabel) {
        Intrinsics.checkNotNullParameter((Object)oldLabel, (String)"oldLabel");
        Intrinsics.checkNotNullParameter((Object)newLabel, (String)"newLabel");
        if (Intrinsics.areEqual((Object)this.node.start, (Object)oldLabel)) {
            this.node.start = newLabel;
        }
        if (Intrinsics.areEqual((Object)this.node.end, (Object)oldLabel)) {
            this.node.end = newLabel;
        }
    }
}

