/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.intellij.collaboration.auth.ObservableAccountsRepository;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;

@State(name="GithubAccounts", storages={@Storage(value="github.xml"), @Storage(value="github_settings.xml", deprecated=true)}, reportStatistic=false, category=SettingsCategory.TOOLS)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0016R0\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GHPersistentAccounts;", "Lcom/intellij/collaboration/auth/ObservableAccountsRepository;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "", "<init>", "()V", "value", "", "accounts", "getAccounts", "()Ljava/util/Set;", "setAccounts", "(Ljava/util/Set;)V", "accountsFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "getAccountsFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "getState", "()[Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "loadState", "", "state", "([Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;)V", "noStateLoaded", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPersistentAccounts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPersistentAccounts.kt\norg/jetbrains/plugins/github/authentication/accounts/GHPersistentAccounts\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,37:1\n37#2,2:38\n*S KotlinDebug\n*F\n+ 1 GHPersistentAccounts.kt\norg/jetbrains/plugins/github/authentication/accounts/GHPersistentAccounts\n*L\n27#1:38,2\n*E\n"})
public final class GHPersistentAccounts
implements ObservableAccountsRepository<GithubAccount>,
PersistentStateComponent<GithubAccount[]> {
    @NotNull
    private final MutableStateFlow<Set<GithubAccount>> accountsFlow = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());

    @NotNull
    public Set<GithubAccount> getAccounts() {
        return (Set)this.getAccountsFlow().getValue();
    }

    public void setAccounts(@NotNull Set<GithubAccount> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getAccountsFlow().setValue(value);
    }

    @NotNull
    public MutableStateFlow<Set<GithubAccount>> getAccountsFlow() {
        return this.accountsFlow;
    }

    @NotNull
    public GithubAccount[] getState() {
        Collection $this$toTypedArray$iv = (Collection)this.getAccountsFlow().getValue();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new GithubAccount[0]);
    }

    public void loadState(@NotNull GithubAccount[] state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.getAccountsFlow().setValue((Object)ArraysKt.toSet((Object[])state2));
    }

    public void noStateLoaded() {
        this.loadState(new GithubAccount[0]);
    }
}

