/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionKt;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J/\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/Maven4RedundantParentCoordinatesInspection;", "Lcom/intellij/codeInspection/XmlSuppressableInspectionTool;", "<init>", "()V", "getShortName", "", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getCleanParentFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "mavenParent", "Lorg/jetbrains/idea/maven/dom/model/MavenDomParent;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMaven4RedundantParentCoordinatesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Maven4RedundantParentCoordinatesInspection.kt\norg/jetbrains/idea/maven/dom/inspections/Maven4RedundantParentCoordinatesInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,88:1\n774#2:89\n865#2,2:90\n1617#2,9:92\n1869#2:101\n1870#2:103\n1626#2:104\n1563#2:105\n1634#2,3:106\n1#3:102\n37#4,2:109\n*S KotlinDebug\n*F\n+ 1 Maven4RedundantParentCoordinatesInspection.kt\norg/jetbrains/idea/maven/dom/inspections/Maven4RedundantParentCoordinatesInspection\n*L\n54#1:89\n54#1:90,2\n55#1:92,9\n55#1:101\n55#1:103\n55#1:104\n56#1:105\n56#1:106,3\n55#1:102\n62#1:109,2\n*E\n"})
public final class Maven4RedundantParentCoordinatesInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public String getShortName() {
        return "Maven4RedundantParentCoordinates";
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (file2 instanceof XmlFile && file2.isPhysical()) {
            PsiDirectory psiDirectory;
            MavenDistribution mavenDistribution = MavenDistributionsCache.getInstance(((XmlFile)file2).getProject()).getMavenDistribution(((XmlFile)file2).getVirtualFile());
            Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"getMavenDistribution(...)");
            MavenDistribution dist = mavenDistribution;
            if (!MavenDistributionKt.isMaven4(dist)) {
                return null;
            }
            DomFileElement domFileElement = DomManager.getDomManager((Project)file2.getProject()).getFileElement((XmlFile)file2, MavenDomProjectModel.class);
            if (domFileElement == null) {
                return null;
            }
            DomFileElement dom = domFileElement;
            DomElement domElement = dom.getRootElement();
            Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"getRootElement(...)");
            MavenDomProjectModel model = (MavenDomProjectModel)domElement;
            String declaredParentGroupId = model.getMavenParent().getGroupId().getStringValue();
            String declaredParentVersion = model.getMavenParent().getVersion().getStringValue();
            String declaredParentArtifactId = model.getMavenParent().getArtifactId().getStringValue();
            CharSequence charSequence = declaredParentGroupId;
            if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)declaredParentVersion) == null || charSequence.length() == 0)) {
                return null;
            }
            PsiFile psiFile = (PsiFile)model.getMavenParent().getRelativePath().getValue();
            if (psiFile == null && ((psiDirectory = ((XmlFile)file2).getParent()) != null && (psiDirectory = psiDirectory.getParent()) != null ? psiDirectory.findFile("pom.xml") : (psiFile = null)) == null) {
                return null;
            }
            PsiFile parentFile = psiFile;
            if (parentFile instanceof XmlFile && parentFile.isPhysical()) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Object it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                DomFileElement domFileElement2 = DomManager.getDomManager((Project)project2).getFileElement((XmlFile)parentFile, MavenDomProjectModel.class);
                if (domFileElement2 == null) {
                    return null;
                }
                DomFileElement parentDom = domFileElement2;
                DomElement domElement2 = parentDom.getRootElement();
                Intrinsics.checkNotNullExpressionValue((Object)domElement2, (String)"getRootElement(...)");
                MavenDomProjectModel parentModel = (MavenDomProjectModel)domElement2;
                String parentGroupId = parentModel.getGroupId().getStringValue();
                String parentVersion = parentModel.getVersion().getStringValue();
                String parentArtifactId = parentModel.getArtifactId().getStringValue();
                if (!Intrinsics.areEqual((Object)declaredParentGroupId, (Object)parentGroupId)) {
                    return null;
                }
                if (!Intrinsics.areEqual((Object)declaredParentVersion, (Object)parentVersion)) {
                    return null;
                }
                if (!Intrinsics.areEqual((Object)declaredParentArtifactId, (Object)parentArtifactId)) {
                    return null;
                }
                MavenDomParent mavenDomParent = model.getMavenParent();
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomParent, (String)"getMavenParent(...)");
                LocalQuickFix fix2 = this.getCleanParentFix(mavenDomParent);
                Object object = new GenericDomValue[]{model.getMavenParent().getGroupId(), model.getMavenParent().getArtifactId(), model.getMavenParent().getVersion()};
                object = CollectionsKt.listOf((Object[])object);
                boolean $i$f$filter = false;
                void var20_20 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (GenericDomValue)element$iv$iv;
                    boolean bl = false;
                    if (!it.exists()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    XmlTag it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl = false;
                    GenericDomValue it2 = (GenericDomValue)element$iv$iv;
                    boolean bl2 = false;
                    if (it2.getXmlTag() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (XmlTag)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(manager.createProblemDescriptor((PsiElement)it, MavenDomBundle.message("inspection.redundant.parent.coordinates.maven.4", new Object[0]), fix2, ProblemHighlightType.WARNING, isOnTheFly));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new ProblemDescriptor[0]);
            }
        }
        return null;
    }

    private final LocalQuickFix getCleanParentFix(MavenDomParent mavenParent) {
        return new LocalQuickFix(mavenParent){
            final /* synthetic */ MavenDomParent $mavenParent;
            {
                this.$mavenParent = $mavenParent;
            }

            public String getFamilyName() {
                String string = MavenDomBundle.message("inspection.redundant.parent.coordinates.maven.4", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getName() {
                String string = MavenDomBundle.message("inspection.redundant.parent.coordinates.maven.4.clean", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public void applyFix(Project project, ProblemDescriptor descriptor2) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    XmlTag xmlTag = this.$mavenParent.getGroupId().getXmlTag();
                    if (xmlTag != null) {
                        xmlTag.delete();
                    }
                    XmlTag xmlTag2 = this.$mavenParent.getArtifactId().getXmlTag();
                    if (xmlTag2 != null) {
                        xmlTag2.delete();
                    }
                    XmlTag xmlTag3 = this.$mavenParent.getVersion().getXmlTag();
                    if (xmlTag3 != null) {
                        xmlTag3.delete();
                    }
                    XmlTag xmlTag4 = this.$mavenParent.getXmlTag();
                    if (xmlTag4 == null) break block3;
                    xmlTag4.collapseIfEmpty();
                }
            }
        };
    }
}

