/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ConcurrencyUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a.\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a0\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a5\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u000b\u0010\u0011\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a.\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0016"}, d2={"whenTaskCanceled", "", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "callback", "Lkotlin/Function0;", "submitProgressStarted", "taskNotificationListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "eventId", "", "defaultMessage", "", "submitProgressFinished", "submitProgressFailed", "message", "Lcom/intellij/build/events/BuildEventsNls$Message;", "error", "", "submitProgressStatus", "intellij.gradle"})
public final class GradleExecutionAwareUtilsKt {
    public static final void whenTaskCanceled(@NotNull ExternalSystemTask task, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Runnable runnable = ConcurrencyUtil.once(() -> GradleExecutionAwareUtilsKt.whenTaskCanceled$lambda$0(callback));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"once(...)");
        Runnable wrappedCallback = runnable;
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        ExternalSystemTaskNotificationListener notificationListener2 = new ExternalSystemTaskNotificationListener(wrappedCallback){
            final /* synthetic */ Runnable $wrappedCallback;
            {
                this.$wrappedCallback = $wrappedCallback;
            }

            public void onCancel(String projectPath, ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.$wrappedCallback.run();
            }
        };
        progressManager.addNotificationListener(task.getId(), notificationListener2);
        if (task.getState() == ExternalSystemTaskState.CANCELED || task.getState() == ExternalSystemTaskState.CANCELING) {
            wrappedCallback.run();
        }
    }

    public static final void submitProgressStarted(@NotNull ExternalSystemTask task, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull ProgressIndicator progressIndicator, @NotNull Object eventId, @NotNull String defaultMessage) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)defaultMessage, (String)"defaultMessage");
        String string = progressIndicator.getText();
        if (string == null) {
            string = defaultMessage;
        }
        String message = string;
        StartEventImpl buildEvent = new StartEventImpl(eventId, (Object)task.getId(), System.currentTimeMillis(), message);
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(task.getId(), (BuildEvent)buildEvent);
        taskNotificationListener.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    public static final void submitProgressFinished(@NotNull ExternalSystemTask task, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @Nullable ProgressIndicator progressIndicator, @NotNull Object eventId, @NotNull String defaultMessage) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)defaultMessage, (String)"defaultMessage");
        ProgressIndicator progressIndicator2 = progressIndicator;
        EventResult result = (progressIndicator2 != null ? progressIndicator2.isCanceled() : false) ? (EventResult)new SkippedResultImpl() : (EventResult)new SuccessResultImpl();
        Object object = progressIndicator;
        if (object == null || (object = object.getText()) == null) {
            object = defaultMessage;
        }
        Object message = object;
        FinishEventImpl buildEvent = new FinishEventImpl(eventId, (Object)task.getId(), System.currentTimeMillis(), (String)message, result);
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(task.getId(), (BuildEvent)buildEvent);
        taskNotificationListener.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    public static final void submitProgressFailed(@NotNull ExternalSystemTask task, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Object eventId, @NotNull String message, @Nullable Throwable error) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        FailureResultImpl result = new FailureResultImpl(message, error);
        FinishEventImpl buildEvent = new FinishEventImpl(eventId, (Object)task.getId(), System.currentTimeMillis(), message, (EventResult)result);
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(task.getId(), (BuildEvent)buildEvent);
        taskNotificationListener.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    public static final void submitProgressStatus(@NotNull ExternalSystemTask task, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull ProgressIndicator progressIndicator, @NotNull Object eventId, @NotNull String defaultMessage) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)defaultMessage, (String)"defaultMessage");
        long progress = (long)(progressIndicator.getFraction() * (double)100);
        String string = progressIndicator.getText();
        if (string == null) {
            string = defaultMessage;
        }
        String message = string;
        ProgressBuildEventImpl buildEvent = new ProgressBuildEventImpl(eventId, (Object)task.getId(), System.currentTimeMillis(), message, 100L, progress, "%");
        ExternalSystemBuildEvent notificationEvent = new ExternalSystemBuildEvent(task.getId(), (BuildEvent)buildEvent);
        taskNotificationListener.onStatusChange((ExternalSystemTaskNotificationEvent)notificationEvent);
    }

    private static final void whenTaskCanceled$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

