/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.MouseClickInfo;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.fixture.JPopupMenuFixture;
import org.assertj.swing.fixture.JTreeFixture;
import org.assertj.swing.fixture.JTreeNodeFixture;

public class JTreeRowFixture
implements JTreeNodeFixture<JTreeRowFixture> {
    private final int index;
    private final JTreeFixture tree;

    protected JTreeRowFixture(@Nonnull JTreeFixture tree, int index) {
        this.tree = tree;
        this.index = index;
    }

    @Override
    @Nonnull
    public JTreeRowFixture expand() {
        this.tree.expandRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture collapse() {
        this.tree.collapseRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture select() {
        this.tree.selectRow(this.index);
        return this;
    }

    @Nonnull
    public JTreeRowFixture unselect() {
        this.tree.unselectRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture click() {
        this.tree.clickRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture click(@Nonnull MouseButton button) {
        this.tree.clickRow(this.index, button);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture click(@Nonnull MouseClickInfo mouseClickInfo) {
        this.tree.clickRow(this.index, mouseClickInfo);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture doubleClick() {
        this.tree.doubleClickRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture rightClick() {
        this.tree.rightClickRow(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture drag() {
        this.tree.drag(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JTreeRowFixture drop() {
        this.tree.drop(this.index);
        return this;
    }

    @Override
    @Nonnull
    public JPopupMenuFixture showPopupMenu() {
        return this.tree.showPopupMenuAt(this.index);
    }

    @Override
    @Nullable
    public String value() {
        return this.tree.valueAt(this.index);
    }

    public int index() {
        return this.index;
    }

    @Nonnull
    @VisibleForTesting
    JTreeFixture treeFixture() {
        return this.tree;
    }
}

